/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.EdgeFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeTypeFilter
extends EdgeFilter {
    private HashSet<String> allowedPrefixTypes = new HashSet();
    private HashSet<String> allowedPostfixTypes = new HashSet();
    private ArrayList<Listener> listeners = new ArrayList();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public Set<String> getAllowedPrefixTypes() {
        return Collections.unmodifiableSet(this.allowedPrefixTypes);
    }

    public Set<String> getAllowedPostfixTypes() {
        return Collections.unmodifiableSet(this.allowedPostfixTypes);
    }

    public EdgeTypeFilter(String ... allowedPrefixTypes) {
        this.allowedPrefixTypes.addAll(Arrays.asList(allowedPrefixTypes));
    }

    private void fireChanged(String type) {
        for (Listener l : this.listeners) {
            l.changed(type);
        }
    }

    public void addAllowedPrefixType(String type) {
        this.allowedPrefixTypes.add(type);
        this.fireChanged(type);
    }

    public void addAllowedPostfixType(String type) {
        this.allowedPostfixTypes.add(type);
        this.fireChanged(type);
    }

    public void removeAllowedPrefixType(String type) {
        this.allowedPrefixTypes.remove(type);
        this.fireChanged(type);
    }

    public void removeAllowedPostfixType(String type) {
        this.allowedPostfixTypes.remove(type);
        this.fireChanged(type);
    }

    public EdgeTypeFilter(Set<String> allowedPrefixTypes) {
        this.allowedPrefixTypes.addAll(allowedPrefixTypes);
    }

    @Override
    public Collection<Edge> filterEdges(Collection<Edge> original) {
        ArrayList<Edge> result = new ArrayList<Edge>(original.size());
        for (Edge edge : original) {
            boolean postfixAllowed;
            boolean prefixAllowed = edge.getTypePrefix().equals("") || this.allowedPrefixTypes.contains(edge.getTypePrefix());
            boolean bl = postfixAllowed = edge.getTypePostfix().equals("") || this.allowedPostfixTypes.contains(edge.getTypePostfix());
            if (!prefixAllowed || !postfixAllowed) continue;
            result.add(edge);
        }
        return result;
    }

    public boolean allowsPrefix(String type) {
        return this.allowedPrefixTypes.contains(type);
    }

    public boolean allowsPostfix(String type) {
        return this.allowedPostfixTypes.contains(type);
    }

    public static interface Listener {
        public void changed(String var1);
    }
}

