/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.ControllerPanel;
import com.googlecode.whatswrong.EdgeTypeFilter;
import com.googlecode.whatswrong.NLPCanvas;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeTypeFilterPanel
extends ControllerPanel
implements NLPCanvas.Listener,
EdgeTypeFilter.Listener {
    private NLPCanvas nlpCanvas;
    private JList types;
    private DefaultListModel listModel;
    private JCheckBox matches;
    private JCheckBox falsePositives;
    private JCheckBox falseNegatives;
    private HashSet<String> justChanged = new HashSet();
    private EdgeTypeFilter edgeTypeFilter;

    public EdgeTypeFilterPanel(final NLPCanvas nlpCanvas, final EdgeTypeFilter edgeTypeFilter) {
        this.edgeTypeFilter = edgeTypeFilter;
        this.setLayout(new GridBagLayout());
        nlpCanvas.addListener(this);
        edgeTypeFilter.addListener(this);
        this.nlpCanvas = nlpCanvas;
        this.listModel = new DefaultListModel();
        this.types = new JList(this.listModel);
        this.types.setSelectionMode(2);
        this.matches = new JCheckBox("Matches");
        this.falsePositives = new JCheckBox("False Positives");
        this.falseNegatives = new JCheckBox("False Negatives");
        this.updateTypesList();
        this.updateSelection();
        this.types.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EdgeTypeFilterPanel.this.justChanged.clear();
                if (e.getFirstIndex() == -1 || e.getLastIndex() >= EdgeTypeFilterPanel.this.types.getModel().getSize()) {
                    return;
                }
                for (int index = e.getFirstIndex(); index < e.getLastIndex() + 1; ++index) {
                    String type = EdgeTypeFilterPanel.this.types.getModel().getElementAt(index).toString();
                    EdgeTypeFilterPanel.this.justChanged.add(type);
                    if (EdgeTypeFilterPanel.this.types.isSelectedIndex(index)) {
                        edgeTypeFilter.addAllowedPrefixType(type);
                        continue;
                    }
                    edgeTypeFilter.removeAllowedPrefixType(type);
                }
                EdgeTypeFilterPanel.this.justChanged.clear();
                nlpCanvas.updateNLPGraphics();
            }
        });
        JScrollPane pane = new JScrollPane(this.types);
        this.add((Component)pane, new SimpleGridBagConstraints(0, 0, 2, 2));
        pane.setPreferredSize(new Dimension(150, 70));
        this.matches.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EdgeTypeFilterPanel.this.matches.isSelected()) {
                    edgeTypeFilter.addAllowedPostfixType("Match");
                } else {
                    edgeTypeFilter.removeAllowedPostfixType("Match");
                }
                EdgeTypeFilterPanel.this.justChanged.clear();
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.falseNegatives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EdgeTypeFilterPanel.this.falseNegatives.isSelected()) {
                    edgeTypeFilter.addAllowedPostfixType("FN");
                } else {
                    edgeTypeFilter.removeAllowedPostfixType("FN");
                }
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.falsePositives.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EdgeTypeFilterPanel.this.falsePositives.isSelected()) {
                    edgeTypeFilter.addAllowedPostfixType("FP");
                } else {
                    edgeTypeFilter.removeAllowedPostfixType("FP");
                }
                nlpCanvas.updateNLPGraphics();
            }
        });
        this.add((Component)this.matches, new SimpleGridBagConstraints(0, 2, 2, 1));
        this.add((Component)this.falsePositives, new SimpleGridBagConstraints(0, 3, 2, 1));
        this.add((Component)this.falseNegatives, new SimpleGridBagConstraints(0, 4, 2, 1));
    }

    private void separateTypes(Set<String> usedTypes, HashSet<String> prefixTypes, HashSet<String> postfixTypes) {
        for (String type : usedTypes) {
            int index = type.indexOf(58);
            if (index == -1) {
                prefixTypes.add(type);
                continue;
            }
            prefixTypes.add(type.substring(0, index));
            postfixTypes.add(type.substring(index + 1));
        }
    }

    private void updateSelection() {
        ListSelectionModel selectionModel = this.types.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        for (int index = 0; index < this.types.getModel().getSize(); ++index) {
            String type = this.types.getModel().getElementAt(index).toString();
            if (!this.edgeTypeFilter.allowsPrefix(type)) continue;
            selectionModel.addSelectionInterval(index, index);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    private void updateTypesList() {
        HashSet<String> prefixTypes = new HashSet<String>();
        HashSet<String> postfixTypes = new HashSet<String>();
        this.separateTypes(this.nlpCanvas.getUsedTypes(), prefixTypes, postfixTypes);
        ArrayList<String> allTypes = new ArrayList<String>();
        allTypes.addAll(prefixTypes);
        this.falsePositives.setEnabled(postfixTypes.contains("FP"));
        this.falsePositives.setSelected(this.edgeTypeFilter.allowsPostfix("FP"));
        this.falseNegatives.setEnabled(postfixTypes.contains("FN"));
        this.falseNegatives.setSelected(this.edgeTypeFilter.allowsPostfix("FN"));
        this.matches.setEnabled(postfixTypes.contains("Match"));
        this.matches.setSelected(this.edgeTypeFilter.allowsPostfix("Match"));
        this.listModel.clear();
        for (String type : allTypes) {
            this.listModel.addElement(type);
        }
    }

    @Override
    public void instanceChanged() {
        this.updateTypesList();
        this.updateSelection();
        this.repaint();
    }

    @Override
    public void redrawn() {
    }

    @Override
    public void changed(String type) {
        if (!this.justChanged.contains(type)) {
            this.updateSelection();
        }
    }
}

