/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class FilterTextField
extends JTextField {
    private boolean sendsNotificationForEachKeystroke = false;
    private boolean showingPlaceholderText = false;

    public FilterTextField(String placeholderText) {
        this.addFocusListener(new PlaceholderText(placeholderText));
        this.initKeyListener();
    }

    public FilterTextField() {
        this("Search");
    }

    private void initKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FilterTextField.this.cancel();
                } else if (FilterTextField.this.sendsNotificationForEachKeystroke) {
                    FilterTextField.this.maybeNotify();
                }
            }
        });
    }

    private void cancel() {
        this.setText("");
        this.postActionEvent();
    }

    private void maybeNotify() {
        if (this.showingPlaceholderText) {
            return;
        }
        this.postActionEvent();
    }

    public void setSendsNotificationForEachKeystroke(boolean eachKeystroke) {
        this.sendsNotificationForEachKeystroke = eachKeystroke;
    }

    class PlaceholderText
    implements FocusListener {
        private String placeholderText;
        private String previousText = "";
        private Color previousColor;

        PlaceholderText(String placeholderText) {
            this.placeholderText = placeholderText;
            this.focusLost(null);
        }

        public void focusGained(FocusEvent e) {
            FilterTextField.this.setForeground(this.previousColor);
            FilterTextField.this.setText(this.previousText);
            FilterTextField.this.showingPlaceholderText = false;
        }

        public void focusLost(FocusEvent e) {
            this.previousText = FilterTextField.this.getText();
            this.previousColor = FilterTextField.this.getForeground();
            if (this.previousText.length() == 0) {
                FilterTextField.this.showingPlaceholderText = true;
                FilterTextField.this.setForeground(Color.GRAY);
                FilterTextField.this.setText(this.placeholderText);
            }
        }
    }
}

