/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class MoveWindow
extends JWindow
implements MouseListener,
MouseMotionListener {
    Point location;
    MouseEvent pressed;
    private JPanel contentPane;
    private JLabel titleLabel;

    public MoveWindow(Frame owner, String title) {
        super(owner);
        this.getContentPane().setLayout(new BorderLayout());
        this.titleLabel = new JLabel(title);
        this.titleLabel.setBackground(Color.LIGHT_GRAY);
        this.titleLabel.setForeground(Color.WHITE);
        this.titleLabel.setOpaque(true);
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.contentPane = new JPanel();
        this.getContentPane().add((Component)this.contentPane, "Center");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                MoveWindow.this.titleLabel.setBackground(Color.GRAY);
            }

            public void windowLostFocus(WindowEvent e) {
                MoveWindow.this.titleLabel.setBackground(Color.LIGHT_GRAY);
            }
        });
    }

    public JComponent getInternalContent() {
        return this.contentPane;
    }

    public void mousePressed(MouseEvent me) {
        this.pressed = me;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent me) {
        this.location = this.getLocation(this.location);
        int x = this.location.x - this.pressed.getX() + me.getX();
        int y = this.location.y - this.pressed.getY() + me.getY();
        this.setLocation(x, y);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public static void main(String[] args) {
        MoveWindow window = new MoveWindow(null, "Test");
        window.setSize(300, 300);
        window.setLocationRelativeTo(null);
        window.setVisible(true);
    }
}

