/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.AlignmentRenderer;
import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPCanvasRenderer;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.NLPInstanceFilter;
import com.googlecode.whatswrong.SingleSentenceRenderer;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenProperty;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLPCanvas
extends JPanel {
    private final HashMap<NLPInstance.RenderType, NLPCanvasRenderer> renderers = new HashMap();
    private JTextArea textArea = null;
    private ArrayList<Token> tokens = new ArrayList();
    private LinkedList<Edge> dependencies = new LinkedList();
    private BufferedImage image = new BufferedImage(1, 1, 6);
    private Set<String> usedTypes = new HashSet<String>();
    private Set<TokenProperty> usedProperties = new HashSet<TokenProperty>();
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private NLPInstance instance;
    private NLPInstanceFilter filter;
    private NLPCanvasRenderer renderer = new SingleSentenceRenderer();
    private ArrayList<Listener> listeners = new ArrayList();

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    public NLPCanvas() {
        this.setPreferredSize(new Dimension(300, 300));
        this.setOpaque(true);
        this.renderers.put(NLPInstance.RenderType.single, this.renderer);
        this.renderers.put(NLPInstance.RenderType.alignment, new AlignmentRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point point = e.getPoint();
                int offset = NLPCanvas.this.getHeight() - NLPCanvas.this.image.getHeight();
                point.translate(0, -offset);
                Edge edge = NLPCanvas.this.renderer.getEdgeAt(point, 5);
                if (edge != null) {
                    NLPCanvas.this.textArea.append(edge + ": " + edge.getDescription() + "\n");
                }
            }
        });
    }

    public NLPCanvasRenderer getRenderer() {
        return this.renderer;
    }

    public void addChangeListenger(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    private void fireChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(event);
        }
    }

    private void fireInstanceChanged() {
        for (Listener l : this.listeners) {
            l.instanceChanged();
        }
    }

    private void fireRedrawn() {
        for (Listener l : this.listeners) {
            l.redrawn();
        }
    }

    public void setNLPInstance(NLPInstance nlpInstance) {
        this.instance = nlpInstance;
        this.dependencies.clear();
        this.dependencies.addAll(nlpInstance.getEdges());
        this.usedTypes.clear();
        for (Edge edge : this.dependencies) {
            this.usedTypes.add(edge.getType());
        }
        this.tokens.clear();
        this.tokens.addAll(nlpInstance.getTokens());
        this.usedProperties.clear();
        for (Token token : this.tokens) {
            this.usedProperties.addAll(token.getPropertyTypes());
        }
        this.fireInstanceChanged();
    }

    public Set<TokenProperty> getUsedProperties() {
        return Collections.unmodifiableSet(this.usedProperties);
    }

    public Set<String> getUsedTypes() {
        return Collections.unmodifiableSet(this.usedTypes);
    }

    public NLPInstanceFilter getFilter() {
        return this.filter;
    }

    public void setFilter(NLPInstanceFilter filter) {
        this.filter = filter;
    }

    private NLPInstance filterInstance() {
        return this.filter.filter(new NLPInstance(this.tokens, this.dependencies, this.instance.getRenderType(), this.instance.getSplitPoints()));
    }

    public void updateNLPGraphics() {
        NLPInstance filtered = this.filterInstance();
        Graphics2D graphics = this.image.createGraphics();
        this.renderer = this.renderers.get((Object)filtered.getRenderType());
        Dimension dim = this.renderer.render(filtered, graphics);
        this.image = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), 6);
        graphics = this.image.createGraphics();
        this.renderer.render(filtered, graphics);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setSize(new Dimension(dim.width, this.getHeight()));
        this.repaint();
        this.invalidate();
        this.fireChanged();
        this.fireRedrawn();
    }

    public void clear() {
        this.tokens.clear();
        this.dependencies.clear();
        this.usedTypes.clear();
        this.usedProperties.clear();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        int y = this.getHeight() - this.image.getHeight();
        g2d.drawImage((Image)this.image, 0, y, this);
    }

    public void exportToEPS(File file) throws IOException {
        EpsGraphics dummy = new EpsGraphics("Title", (OutputStream)new ByteArrayOutputStream(), 0, 0, 1, 1, ColorMode.BLACK_AND_WHITE);
        NLPInstance filtered = this.filterInstance();
        Dimension dim = this.renderer.render(filtered, (Graphics2D)dummy);
        EpsGraphics g = new EpsGraphics("Title", (OutputStream)new FileOutputStream(file), 0, 0, (int)dim.getWidth() + 2, (int)dim.getHeight(), ColorMode.COLOR_RGB);
        this.renderer.render(filtered, (Graphics2D)g);
        g.flush();
        g.close();
    }

    public static interface Listener {
        public void instanceChanged();

        public void redrawn();
    }
}

