/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLPInstance {
    private RenderType renderType = RenderType.single;
    private List<Edge> edges = new ArrayList<Edge>();
    private List<Token> tokens = new ArrayList<Token>();
    private HashMap<Integer, Token> map = new HashMap();
    private ArrayList<Integer> splitPoints = new ArrayList();

    public NLPInstance() {
    }

    public NLPInstance(Collection<Token> tokens, Collection<Edge> edges, RenderType renderType, List<Integer> splitPoints) {
        this.tokens.addAll(tokens);
        for (Token t : tokens) {
            this.map.put(t.getIndex(), t);
        }
        this.edges.addAll(edges);
        this.renderType = renderType;
        this.splitPoints.addAll(splitPoints);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public void addEdge(int from, int to, String label, String type) {
        if (this.isInvalidEdge(from, to)) {
            return;
        }
        this.edges.add(new Edge(this.map.get(from), this.map.get(to), label, type));
    }

    public void addEdge(int from, int to, String label, String type, Edge.RenderType renderType) {
        if (this.isInvalidEdge(from, to)) {
            return;
        }
        this.edges.add(new Edge(this.map.get(from), this.map.get(to), label, type, renderType));
    }

    public void addEdge(Edge edge) {
        this.edges.add(new Edge(this.map.get(edge.getFrom().getIndex()), this.map.get(edge.getTo().getIndex()), edge.getLabel(), edge.getNote(), edge.getType(), edge.getRenderType(), edge.getDescription()));
    }

    public void addSpan(int from, int to, String label, String type) {
        if (this.isInvalidEdge(from, to)) {
            return;
        }
        this.edges.add(new Edge(this.map.get(from), this.map.get(to), label, type, Edge.RenderType.span));
    }

    private boolean isInvalidEdge(int from, int to) {
        Token fromToken = this.map.get(from);
        Token toToken = this.map.get(to);
        if (fromToken == null) {
            System.out.println("There is no token at index " + from + " for tokens " + this.map);
        }
        if (toToken == null) {
            System.out.println("There is no token at index " + to + " for tokens " + this.map);
        }
        return toToken == null || fromToken == null;
    }

    public void addSpan(int from, int to, String label, String type, String description) {
        if (this.isInvalidEdge(from, to)) {
            return;
        }
        Edge edge = new Edge(this.map.get(from), this.map.get(to), label, type, Edge.RenderType.span);
        edge.setDescription(description);
        this.edges.add(edge);
    }

    public void addDependency(int from, int to, String label, String type) {
        if (this.isInvalidEdge(from, to)) {
            return;
        }
        this.edges.add(new Edge(this.map.get(from), this.map.get(to), label, type, Edge.RenderType.dependency));
    }

    public void addDependency(int from, int to, String label, String type, String description) {
        if (this.isInvalidEdge(from, to)) {
            return;
        }
        Token fromToken = this.map.get(from);
        Token toToken = this.map.get(to);
        Edge edge = new Edge(fromToken, toToken, label, type, Edge.RenderType.dependency);
        edge.setDescription(description);
        this.edges.add(edge);
    }

    public void addEdge(Token from, Token to, String label, String type) {
        this.addEdge(from.getIndex(), to.getIndex(), label, type);
    }

    public void addEdge(Token from, Token to, String label, String type, Edge.RenderType renderType) {
        this.addEdge(from.getIndex(), to.getIndex(), label, type, renderType);
    }

    public void addTokens(Collection<Token> tokens) {
        this.tokens.addAll(tokens);
        for (Token t : tokens) {
            this.map.put(t.getIndex(), t);
        }
    }

    public void addEdges(Collection<Edge> edges) {
        this.edges.addAll(edges);
    }

    public void merge(NLPInstance nlp) {
        for (int i = 0; i < Math.min(this.tokens.size(), nlp.tokens.size()); ++i) {
            this.tokens.get(i).merge(nlp.tokens.get(i));
        }
        for (Edge edge : nlp.edges) {
            this.addEdge(edge.getFrom().getIndex(), edge.getTo().getIndex(), edge.getLabel(), edge.getType(), edge.getRenderType());
        }
    }

    public void addTokenWithProperties(String ... properties) {
        Token token = new Token(this.tokens.size());
        for (String property : properties) {
            token.addProperty(property);
        }
        this.tokens.add(token);
        this.map.put(token.getIndex(), token);
    }

    public Token addToken() {
        Token vertex = new Token(this.tokens.size());
        this.tokens.add(vertex);
        this.map.put(vertex.getIndex(), vertex);
        return vertex;
    }

    public Token addToken(int index) {
        Token vertex = this.map.get(index);
        if (vertex == null) {
            vertex = new Token(index);
            this.map.put(index, vertex);
        }
        return vertex;
    }

    public void consistify() {
        this.tokens.addAll(this.map.values());
        Collections.sort(this.tokens);
    }

    public void addSplitPoint(int tokenIndex) {
        this.splitPoints.add(tokenIndex);
    }

    public List<Integer> getSplitPoints() {
        return Collections.unmodifiableList(this.splitPoints);
    }

    public List<Edge> getEdges() {
        return Collections.unmodifiableList(this.edges);
    }

    public List<Edge> getEdges(Edge.RenderType renderType) {
        ArrayList<Edge> result = new ArrayList<Edge>(this.edges.size());
        for (Edge e : this.edges) {
            if (e.getRenderType() != renderType) continue;
            result.add(e);
        }
        return result;
    }

    public Token getToken(int index) {
        return this.map.get(index);
    }

    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    public String toString() {
        return this.tokens + "\n" + this.map + "\n" + this.edges;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderType {
        single,
        alignment;

    }
}

