/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.TokenProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements Comparable<Token> {
    private int index;
    private HashMap<TokenProperty, String> tokenProperties = new HashMap();

    public Token(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public Collection<TokenProperty> getPropertyTypes() {
        return Collections.unmodifiableCollection(this.tokenProperties.keySet());
    }

    public String getProperty(TokenProperty property) {
        return this.tokenProperties.get(property);
    }

    public void removeProperty(int index) {
        this.tokenProperties.remove(new TokenProperty(index));
    }

    public void removeProperty(String name) {
        this.tokenProperties.remove(new TokenProperty(name));
    }

    public Token addProperty(String name, String value) {
        this.tokenProperties.put(new TokenProperty(name, this.tokenProperties.size()), value);
        return this;
    }

    public void addProperty(int index, String property) {
        this.tokenProperties.put(new TokenProperty(index), property);
    }

    public Token addProperty(TokenProperty property, String value) {
        this.tokenProperties.put(property, value);
        return this;
    }

    public void addProperty(String value) {
        this.addProperty(this.tokenProperties.size(), value);
    }

    public List<TokenProperty> getSortedProperties() {
        ArrayList<TokenProperty> sorted = new ArrayList<TokenProperty>(this.tokenProperties.keySet());
        Collections.sort(sorted);
        return sorted;
    }

    public Collection<String> getPropertyValues() {
        return Collections.unmodifiableCollection(this.tokenProperties.values());
    }

    public boolean propertiesContain(String substring) {
        for (String property : this.tokenProperties.values()) {
            if (!property.contains(substring)) continue;
            return true;
        }
        return false;
    }

    public boolean propertiesContain(Collection<String> substrings, boolean wholeWord) {
        for (String property : this.tokenProperties.values()) {
            for (String substring : substrings) {
                if (substring.matches("\\d+-\\d+")) {
                    String[] split = substring.split("[-]");
                    int from = Integer.parseInt(split[0]);
                    int to = Integer.parseInt(split[1]);
                    for (int i = from; i <= to; ++i) {
                        if (!property.equals(String.valueOf(i))) continue;
                        return true;
                    }
                    continue;
                }
                if (!(wholeWord ? property.equals(substring) : property.contains(substring))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token that = (Token)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return this.index;
    }

    public void merge(Token token) {
        this.tokenProperties.putAll(token.tokenProperties);
    }

    @Override
    public int compareTo(Token o) {
        return this.index - o.getIndex();
    }

    public String toString() {
        return this.index + ":" + this.tokenProperties;
    }
}

