/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong;

import com.googlecode.whatswrong.AppearancePanel;
import com.googlecode.whatswrong.CorpusLoader;
import com.googlecode.whatswrong.CorpusNavigator;
import com.googlecode.whatswrong.DependencyFilterPanel;
import com.googlecode.whatswrong.EdgeLabelFilter;
import com.googlecode.whatswrong.EdgeTokenFilter;
import com.googlecode.whatswrong.EdgeTypeFilter;
import com.googlecode.whatswrong.EdgeTypeFilterPanel;
import com.googlecode.whatswrong.FilterPipeline;
import com.googlecode.whatswrong.NLPCanvas;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.TokenFilter;
import com.googlecode.whatswrong.TokenFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class WhatsWrongWithMyNLP
extends JPanel {
    private NLPCanvas nlpCanvas = new NLPCanvas();
    private JScrollPane nlpScrollPane = new JScrollPane(this.nlpCanvas);
    public static final String VERSION = "0.2.2";
    private static final Properties properties = new Properties();
    private static final boolean USE_SYSTEM_UI = true;

    public static Properties getProperties() {
        return properties;
    }

    public WhatsWrongWithMyNLP() {
        super(new BorderLayout());
        this.nlpScrollPane.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.nlpScrollPane, "Center");
        this.setMinimumSize(new Dimension(700, 600));
    }

    public NLPCanvas getNlpCanvas() {
        return this.nlpCanvas;
    }

    public void scrollToBottom() {
        this.nlpCanvas.scrollRectToVisible(new Rectangle(this.nlpScrollPane.getViewport().getX(), this.nlpCanvas.getHeight() - this.nlpScrollPane.getViewport().getHeight(), this.nlpScrollPane.getViewport().getWidth(), this.nlpScrollPane.getViewport().getHeight()));
    }

    private static void changeUI(boolean system) {
        try {
            UIManager.setLookAndFeel(system ? UIManager.getSystemLookAndFeelClassName() : UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "What's Wrong ...");
        WhatsWrongWithMyNLP.changeUI(true);
        final NLPCanvas canvas = new NLPCanvas();
        EdgeTokenFilter edgeTokenFilter = new EdgeTokenFilter(new String[0]);
        EdgeLabelFilter edgeLabelFilter = new EdgeLabelFilter(new String[0]);
        TokenFilter tokenFilter = new TokenFilter();
        EdgeTypeFilter edgeTypeFilter = new EdgeTypeFilter(new String[0]);
        FilterPipeline filterPipeline = new FilterPipeline(tokenFilter, edgeTypeFilter, edgeLabelFilter, edgeTokenFilter);
        canvas.setFilter(filterPipeline);
        int canvasWidth = 900;
        int canvasHeight = 300;
        int canvasX = 50;
        int canvasY = 50;
        int canvasBottom = canvasHeight + canvasY;
        final CorpusLoader gold = new CorpusLoader("Select Gold");
        final CorpusLoader guess = new CorpusLoader("Select Guess");
        gold.loadProperties(properties);
        guess.loadProperties(properties);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem exportEps = new JMenuItem("Export EPS");
        final JFileChooser fc = new JFileChooser();
        exportEps.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        exportEps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(canvas);
                if (returnVal == 0) {
                    try {
                        canvas.exportToEPS(fc.getSelectedFile());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        file.add(exportEps);
        file.setMnemonic('F');
        JMenuItem quit = new JMenuItem("Quit");
        file.add(quit);
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        JMenu window = new JMenu("Window");
        menuBar.add(file);
        menuBar.add(window);
        JToolBar toolBar = new JToolBar("Blub");
        toolBar.add(new JButton("Test"));
        JFrame canvasFrame = new JFrame("What's Wrong With My NLP?");
        canvasFrame.setSize(canvasWidth, canvasHeight);
        canvasFrame.getContentPane().setLayout(new BorderLayout());
        canvasFrame.getContentPane().add((Component)new JScrollPane(canvas), "Center");
        canvasFrame.setJMenuBar(menuBar);
        canvasFrame.setLocation(canvasX, canvasY);
        canvasFrame.setDefaultCloseOperation(3);
        ControllerDialog fileWindow = new ControllerDialog("File Selection", true);
        fileWindow.getContentPane().setLayout(new BoxLayout(fileWindow.getContentPane(), 1));
        fileWindow.getContentPane().add(gold);
        fileWindow.getContentPane().add(new JSeparator());
        fileWindow.getContentPane().add(guess);
        fileWindow.setLocation(canvasX + 20, canvasBottom + 20);
        fileWindow.pack();
        fileWindow.setVisible(true);
        window.add(new WindowMenuItem(fileWindow));
        ControllerDialog filterWindow = new ControllerDialog("Edge Filters", false);
        filterWindow.getContentPane().setLayout(new BoxLayout(filterWindow.getContentPane(), 1));
        filterWindow.getContentPane().add(new EdgeTypeFilterPanel(canvas, edgeTypeFilter));
        filterWindow.getContentPane().add(new JSeparator());
        filterWindow.getContentPane().add(new DependencyFilterPanel(canvas, edgeLabelFilter, edgeTokenFilter));
        filterWindow.pack();
        filterWindow.setLocation(canvasX + 250, canvasBottom + 15);
        filterWindow.setVisible(true);
        window.add(new WindowMenuItem(filterWindow));
        ControllerDialog tokenFilterWindow = new ControllerDialog("Token Filters", false);
        tokenFilterWindow.getContentPane().setLayout(new BoxLayout(tokenFilterWindow.getContentPane(), 1));
        tokenFilterWindow.getContentPane().add(new TokenFilterPanel(canvas, tokenFilter));
        tokenFilterWindow.pack();
        tokenFilterWindow.setLocation(canvasX + 360, canvasBottom + 230);
        tokenFilterWindow.setVisible(true);
        window.add(new WindowMenuItem(tokenFilterWindow));
        ControllerDialog appearance = new ControllerDialog("Appearance", false);
        appearance.getContentPane().setLayout(new BoxLayout(appearance.getContentPane(), 1));
        appearance.getContentPane().add(new AppearancePanel(canvas));
        appearance.pack();
        appearance.setLocation(canvasX + 500, canvasBottom + 25);
        appearance.setVisible(true);
        window.add(new WindowMenuItem(appearance));
        ControllerDialog description = new ControllerDialog("Description", true);
        JTextArea text = new JTextArea(15, 40);
        description.getContentPane().add(new JScrollPane(text));
        description.pack();
        description.setLocation(canvasX + 700, canvasBottom + 25);
        description.setVisible(true);
        canvas.setTextArea(text);
        window.add(new WindowMenuItem(description));
        ControllerDialog navigatorWindow = new ControllerDialog("Search Corpus", true);
        navigatorWindow.getContentPane().setLayout(new BoxLayout(navigatorWindow.getContentPane(), 1));
        CorpusNavigator navigator = new CorpusNavigator(canvas, gold, guess, edgeTypeFilter);
        navigatorWindow.getContentPane().add(navigator);
        navigatorWindow.pack();
        navigatorWindow.setMinimumSize(navigatorWindow.getSize());
        navigatorWindow.setLocation(canvasX + 800, canvasBottom + 20);
        navigatorWindow.setVisible(true);
        window.add(new WindowMenuItem(navigatorWindow, "Navigator"));
        JPanel statusBar = new JPanel();
        JLabel status = new JLabel("What's Wrong With My NLP version 0.2.2");
        status.setForeground(Color.LIGHT_GRAY);
        statusBar.setLayout(new GridBagLayout());
        statusBar.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
        statusBar.add(status);
        statusBar.add((Component)navigator.getSpinnerPanel(), new SimpleGridBagConstraints(0, true));
        statusBar.add((Component)navigator.getSpinnerPanel(), new SimpleGridBagConstraints(1, 0, 1.0, 0.0, 13, 0));
        canvasFrame.getContentPane().add((Component)statusBar, "South");
        canvasFrame.setVisible(true);
        canvasFrame.requestFocus();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                gold.saveProperties(properties);
                guess.saveProperties(properties);
                try {
                    properties.store(new FileOutputStream(System.getProperty("user.home") + "/.whatswrong"), "Whats wrong with you NLP properties");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
    }

    static {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        try {
            File file = new File(System.getProperty("user.home") + "/.whatswrong");
            if (file.exists()) {
                properties.load(new FileInputStream(file));
            } else {
                properties.setProperty("whatswrong.golddir", System.getProperty("user.dir"));
                properties.setProperty("whatswrong.guessdir", System.getProperty("user.dir"));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ControllerDialog
    extends JDialog {
        public ControllerDialog(Frame owner, String title, boolean resizable) throws HeadlessException {
            super(owner, title, false);
            this.pack();
            this.setResizable(resizable);
        }

        public ControllerDialog(String title, boolean resizable) {
            this((Frame)null, title, resizable);
        }
    }

    private static class WindowMenuItem
    extends JCheckBoxMenuItem {
        public WindowMenuItem(final JWindow window, String text) {
            super(text, window.isVisible());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    window.setVisible(!window.isVisible());
                }
            });
        }

        public WindowMenuItem(Dialog window) {
            this(window, window.getTitle());
        }

        public WindowMenuItem(final Window window, String title) {
            super(title, window.isVisible());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    window.setVisible(!window.isVisible());
                }
            });
            window.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    WindowMenuItem.this.setSelected(false);
                }

                public void windowOpened(WindowEvent e) {
                    WindowMenuItem.this.setSelected(true);
                }
            });
        }
    }
}

