/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.io.TabFormat;
import com.googlecode.whatswrong.io.TabProcessor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoNLL2004
implements TabProcessor {
    public static final String name = "CoNLL 2004";

    public String toString() {
        return name;
    }

    @Override
    public NLPInstance create(List<? extends List<String>> rows) {
        NLPInstance instance = new NLPInstance();
        int index = 0;
        for (List<String> list : rows) {
            instance.addToken().addProperty("Word", list.get(0)).addProperty("Index", String.valueOf(index));
            ++index;
        }
        int predicateCount = 0;
        index = 0;
        for (List<String> list : rows) {
            if (!list.get(1).equals("-")) {
                String sense = list.get(1);
                instance.addSpan(index, index, sense, "sense");
                TabFormat.extractSpan05(rows, 2 + predicateCount, "role", sense + ":", instance);
                ++predicateCount;
            }
            ++index;
        }
        return instance;
    }

    @Override
    public NLPInstance createOpen(List<? extends List<String>> rows) {
        return null;
    }

    @Override
    public boolean supportsOpen() {
        return false;
    }
}

