/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.io.TabProcessor;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoNLL2006
implements TabProcessor {
    public static final String name = "CoNLL 2006";

    public String toString() {
        return name;
    }

    @Override
    public NLPInstance create(List<? extends List<String>> rows) {
        NLPInstance instance = new NLPInstance();
        instance.addToken().addProperty("Word", "-Root-");
        for (List<String> list : rows) {
            instance.addToken().addProperty("Word", list.get(1)).addProperty("Index", list.get(0)).addProperty("Lemma", list.get(2)).addProperty("CPos", list.get(3)).addProperty("Pos", list.get(4)).addProperty("Feats", list.get(5));
        }
        for (List<String> list : rows) {
            int mod = Integer.parseInt(list.get(0));
            try {
                instance.addEdge(Integer.parseInt(list.get(6)), mod, list.get(7), "dep");
            }
            catch (Exception e) {
                System.err.println("Can't parse dependency");
                instance.getTokens().get(mod).addProperty("DepMissing", "missing");
            }
        }
        return instance;
    }

    @Override
    public NLPInstance createOpen(List<? extends List<String>> rows) {
        return null;
    }

    @Override
    public boolean supportsOpen() {
        return false;
    }
}

