/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.io.CorpusFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaleAlignmentFormat
implements CorpusFormat {
    @Override
    public String getName() {
        return "Gale Alignment";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    @Override
    public JComponent getAccessory() {
        return new JPanel();
    }

    @Override
    public void setMonitor(CorpusFormat.Monitor monitor) {
    }

    @Override
    public void loadProperties(Properties properties, String prefix) {
    }

    @Override
    public void saveProperties(Properties properties, String prefix) {
    }

    @Override
    public List<NLPInstance> load(File file, int from, int to) throws IOException {
        ArrayList<NLPInstance> result = new ArrayList<NLPInstance>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        NLPInstance instance = null;
        int sourceLength = -1;
        int targetLength = -1;
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("<source>")) {
                String content = line.trim().substring(8, line.length() - 9);
                for (String token : content.split("\\s+")) {
                    instance.addToken().addProperty("word", token);
                }
                sourceLength = instance.getTokens().size();
                instance.addSplitPoint(sourceLength);
            } else if (line.startsWith("<seg")) {
                instance = new NLPInstance();
                instance.setRenderType(NLPInstance.RenderType.alignment);
            } else if (line.startsWith("<translation>")) {
                String content = line.trim().substring(13, line.length() - 14);
                for (String token : content.split("\\s+")) {
                    instance.addToken().addProperty("word", token);
                }
                targetLength = instance.getTokens().size() - sourceLength;
            } else if (line.startsWith("<matrix>")) {
                reader.readLine();
                for (int tgt = 0; tgt < targetLength; ++tgt) {
                    line = reader.readLine();
                    String[] col = line.split("\\s+");
                    for (int src = 1; src < col.length; ++src) {
                        if (!col[src].equals("1")) continue;
                        instance.addEdge(src - 1, tgt + sourceLength, "align", "align");
                    }
                }
                result.add(instance);
            }
            line = reader.readLine();
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

