/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.whatswrong.io;

import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SimpleGridBagConstraints;
import com.googlecode.whatswrong.io.CorpusFormat;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispSExprFormat
implements CorpusFormat {
    private JPanel accessory = new JPanel(new GridBagLayout());
    private JTextField word = new JTextField();
    private JTextField tag = new JTextField();
    private JTextField phrase = new JTextField();
    private CorpusFormat.Monitor monitor;

    public LispSExprFormat() {
        this.accessory.add((Component)new JLabel("Choose type names", 0), new SimpleGridBagConstraints(0, 0, 2, 1));
        this.accessory.add((Component)new JLabel("Word:"), new SimpleGridBagConstraints(1, true));
        this.accessory.add((Component)this.word, new SimpleGridBagConstraints(1, false));
        this.accessory.add((Component)new JLabel("Tag:"), new SimpleGridBagConstraints(2, true));
        this.accessory.add((Component)this.tag, new SimpleGridBagConstraints(2, false));
        this.accessory.add((Component)new JLabel("Phrase:"), new SimpleGridBagConstraints(3, true));
        this.accessory.add((Component)this.phrase, new SimpleGridBagConstraints(3, false));
    }

    @Override
    public void setMonitor(CorpusFormat.Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void loadProperties(Properties properties, String prefix) {
        this.word.setText(properties.getProperty(prefix + ".sexpr.word", "Word"));
        this.tag.setText(properties.getProperty(prefix + ".sexpr.tag", "pos"));
        this.phrase.setText(properties.getProperty(prefix + ".sexpr.phrase", "phrase"));
    }

    @Override
    public void saveProperties(Properties properties, String prefix) {
        properties.setProperty(prefix + ".sexpr.word", this.word.getText());
        properties.setProperty(prefix + ".sexpr.tag", this.tag.getText());
        properties.setProperty(prefix + ".sexpr.phrase", this.phrase.getText());
    }

    @Override
    public String getName() {
        return "Lisp S-Expression";
    }

    @Override
    public String getLongName() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public JComponent getAccessory() {
        return this.accessory;
    }

    @Override
    public List<NLPInstance> load(File file, int from, int to) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<NLPInstance> result = new ArrayList<NLPInstance>(1000);
        int instanceNr = 0;
        String line = reader.readLine();
        while (line != null && instanceNr < to) {
            if (!(line = line.trim()).equals("")) {
                if (instanceNr >= from) {
                    Tree tree = new Tree("[root]");
                    tree.consume(tree, line);
                    tree = tree.children.get(0);
                    NLPInstance instance = new NLPInstance();
                    tree.writeTokens(this.word.getText(), this.tag.getText(), instance);
                    tree.writeSpans(this.phrase.getText(), this.tag.getText(), instance);
                    result.add(instance);
                }
                this.monitor.progressed(instanceNr);
                ++instanceNr;
            }
            line = reader.readLine();
        }
        return result;
    }

    private static class Terminal
    extends Tree {
        int index;

        private Terminal(String label, int index) {
            super(label);
            this.index = index;
        }

        boolean isTag() {
            return false;
        }

        public String toString() {
            return this.label;
        }

        boolean isTerminal() {
            return true;
        }

        int getFrom() {
            return this.index;
        }

        int getTo() {
            return this.index;
        }

        void writeTokens(String wordType, String tagType, NLPInstance instance) {
            instance.addToken().addProperty(wordType, this.label).addProperty("Index", String.valueOf(this.index));
        }

        void writeSpans(String labelType, String tagType, NLPInstance instance) {
        }
    }

    private static class Tree {
        ArrayList<Tree> children = new ArrayList();
        String label;

        Tree(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label + this.children;
        }

        void writeSpans(String labelType, String tagType, NLPInstance instance) {
            if (this.isTag()) {
                instance.addSpan(this.getFrom(), this.getTo(), this.label, tagType);
            } else {
                instance.addSpan(this.getFrom(), this.getTo(), this.label, labelType);
            }
            for (Tree tree : this.children) {
                tree.writeSpans(labelType, tagType, instance);
            }
        }

        void writeTokens(String wordType, String tagType, NLPInstance instance) {
            for (Tree tree : this.children) {
                tree.writeTokens(wordType, tagType, instance);
            }
        }

        void consume(Tree tree, String sexpr) {
            Stack<Tree> stack = new Stack<Tree>();
            stack.add(tree);
            int token = 0;
            int i = 0;
            while (i < sexpr.length()) {
                if (sexpr.charAt(i) == '(') {
                    int whitespace = sexpr.indexOf(32, i + 1);
                    int openBracket = sexpr.indexOf(40, i + 1);
                    int labelEnd = openBracket != -1 && openBracket < whitespace ? openBracket : whitespace;
                    String label = sexpr.substring(i + 1, labelEnd);
                    Tree parent = new Tree(label);
                    ((Tree)stack.peek()).children.add(parent);
                    stack.push(parent);
                    i = labelEnd + (labelEnd == whitespace ? 1 : 0);
                    continue;
                }
                if (sexpr.charAt(i) == ')') {
                    stack.pop();
                    ++i;
                    continue;
                }
                if (sexpr.charAt(i) == ' ') {
                    ++i;
                    continue;
                }
                int wordEnd = sexpr.indexOf(41, i);
                String word = sexpr.substring(i, wordEnd);
                ((Tree)stack.pop()).children.add(new Terminal(word, token++));
                i = wordEnd + 1;
            }
        }

        int getFrom() {
            return this.children.get(0).getFrom();
        }

        int getTo() {
            return this.children.get(this.children.size() - 1).getTo();
        }

        boolean isTerminal() {
            return false;
        }

        boolean isTag() {
            return this.children.get(0).isTerminal();
        }

        static class IndexCounter {
            int index;

            IndexCounter(int index) {
                this.index = index;
            }
        }
    }
}

