/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.CallState;
import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.ContinuationContext;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Random;
import java.util.WeakHashMap;

public class ContinuationManager {
    private WeakHashMap mContexts = null;
    private long mContinuationDuration;
    private int mContinuationPurgeFrequency;
    private int mContinuationPurgeScale;
    private Random mRandom = new Random();

    public ContinuationManager() {
        this.mContinuationDuration = ContinuationConfig.getInstance().getContinuationDuration();
        this.mContinuationPurgeFrequency = ContinuationConfig.getInstance().getContinuationPurgeFrequency();
        this.mContinuationPurgeScale = ContinuationConfig.getInstance().getContinuationPurgeScale();
        this.mContexts = new WeakHashMap();
    }

    void purgeContinuations() {
        int purge_decision = -1;
        purge_decision = this.mRandom.nextInt(this.mContinuationPurgeScale);
        if (purge_decision <= this.mContinuationPurgeFrequency) {
            new PurgeContinuations().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(ContinuationContext context) {
        if (null == context) {
            return;
        }
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            this.mContexts.put(context.getId(), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(ContinuationContext context) {
        if (null == context) {
            return;
        }
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            this.mContexts.remove(context.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuationContext getContext(String id) throws CloneNotSupportedException {
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            ContinuationContext result = null;
            this.purgeContinuations();
            ContinuationContext context = (ContinuationContext)this.mContexts.get(id);
            if (context != null) {
                result = context.shouldClone() ? this.cloneContext(id, context) : this.reuseContext(id, context);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallState getCreatedCallState(String id) {
        ContinuationManager continuationManager = this;
        synchronized (continuationManager) {
            CallState result = null;
            this.purgeContinuations();
            ContinuationContext context = (ContinuationContext)this.mContexts.get(id);
            if (context != null) {
                result = context.getCreatedCallState();
            }
            return result;
        }
    }

    private ContinuationContext reuseContext(String id, ContinuationContext context) {
        this.mContexts.remove(id);
        context.resetId();
        this.addContext(context);
        return context;
    }

    private ContinuationContext cloneContext(String id, ContinuationContext context) throws CloneNotSupportedException {
        context = (ContinuationContext)context.clone();
        context.resetId();
        this.addContext(context);
        return context;
    }

    private class PurgeContinuations
    extends Thread {
        private PurgeContinuations() {
        }

        public void run() {
            this.purge();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void purge() {
            ArrayList<String> stale_continuations = new ArrayList<String>();
            try {
                ContinuationContext context = null;
                Iterator iterator = ContinuationManager.this.mContexts.values().iterator();
                while (iterator.hasNext()) {
                    ContinuationContext reference = (ContinuationContext)iterator.next();
                    if (reference == null || (context = reference) == null || context.getStart() > System.currentTimeMillis() - ContinuationManager.this.mContinuationDuration) continue;
                    stale_continuations.add(context.getId());
                }
            }
            catch (ConcurrentModificationException e) {
                int old_priority = Thread.currentThread().getPriority();
                Thread.currentThread().setPriority(10);
                try {
                    PurgeContinuations purgeContinuations = this;
                    synchronized (purgeContinuations) {
                        stale_continuations = null;
                        this.purge();
                    }
                }
                finally {
                    Thread.currentThread().setPriority(old_priority);
                }
            }
            if (stale_continuations != null) {
                Iterator iterator = stale_continuations.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    ContinuationManager.this.mContexts.remove(id);
                }
            }
        }
    }
}

