/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bigdoc.bin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.riversun.finbin.BigBinarySearcher;

public class BinFileSearcher {
    private static final boolean USE_NIO = true;
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_SUB_BUFFER_SIZE = 512;
    public static final int DEFAULT_SUB_THREAD_SIZE = 32;
    private boolean isLoopInprogress = true;
    private BinFileProgressListener bigFileProgressListener;
    private int bufferSize = 0x100000;
    private int subThreadSize = 32;
    private int subBufferSize = 512;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public void cancel() {
        this.cancelled.set(true);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setSubThreadSize(int subThreadSize) {
        this.subThreadSize = subThreadSize;
    }

    public void setSubBufferSize(int subBufferSize) {
        this.subBufferSize = subBufferSize;
    }

    public void setBigFileProgressListener(BinFileProgressListener listener) {
        this.bigFileProgressListener = listener;
    }

    public Long indexOf(File f, byte[] searchBytes) {
        return this.indexOf(f, searchBytes, 0L);
    }

    public Long indexOf(File f, byte[] searchBytes, long fromPosition) {
        List<Long> result = this.searchPartiallyUsingNIO(f, searchBytes, fromPosition, -1L, new BinFileProgressListener(){

            @Override
            public void onProgress(List<Long> pointerList, float progress, float currentPosition, float startPosition, long maxSizeToRead) {
                if (BinFileSearcher.this.bigFileProgressListener != null) {
                    BinFileSearcher.this.bigFileProgressListener.onProgress(pointerList, progress, currentPosition, startPosition, maxSizeToRead);
                }
                if (pointerList.size() > 0) {
                    BinFileSearcher.this.stop();
                }
            }
        });
        if (result.size() > 0) {
            return result.get(0);
        }
        return -1L;
    }

    public List<Long> search(File f, byte[] searchBytes) {
        long startPosition = 0L;
        long maxSizeToRead = -1L;
        return this.searchPartially(f, searchBytes, 0L, -1L);
    }

    public List<Long> searchPartially(File f, byte[] searchBytes, long startPosition, long maxSizeToRead) {
        return this.searchPartiallyUsingNIO(f, searchBytes, startPosition, maxSizeToRead, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> searchPartiallyUsingNIO(File f, byte[] searchBytes, long startPosition, long maxSizeToRead, BinFileProgressListener listener) {
        ArrayList<Long> pointerList = new ArrayList<Long>();
        this.isLoopInprogress = true;
        BigBinarySearcher bbs = new BigBinarySearcher();
        bbs.setMaxNumOfThreads(this.subThreadSize);
        bbs.setBufferSize(this.subBufferSize);
        boolean hasReadingLimit = maxSizeToRead > 0L;
        AbstractInterruptibleChannel readChannel = null;
        try {
            readChannel = FileChannel.open(Paths.get(f.getAbsolutePath(), new String[0]), StandardOpenOption.READ);
            long targetFileSize = ((FileChannel)readChannel).size();
            if (startPosition < 0L || startPosition > targetFileSize) {
                throw new RuntimeException("StartPos is invalid.");
            }
            long endPosition = hasReadingLimit ? (startPosition + maxSizeToRead > targetFileSize ? targetFileSize - 1L : startPosition + maxSizeToRead - 1L) : targetFileSize - 1L;
            long offsetPos = startPosition;
            int byteShiftForSearch = searchBytes.length - 1;
            int actualBufferSize = (int)Math.min((long)this.bufferSize, targetFileSize);
            if (searchBytes.length > actualBufferSize) {
                throw new RuntimeException("The length of the target bytes is less than bufferSize.Please set more bigger bufferSize.");
            }
            MappedByteBuffer mappedByteBuffer = null;
            byte[] buf = new byte[actualBufferSize];
            while (this.isLoopInprogress) {
                if (this.cancelled.get()) {
                } else {
                    int bytesToBeEatByBigBinSearcher;
                    byte[] bufForSearch;
                    int bytesToBeRead = (int)Math.min((long)actualBufferSize, targetFileSize - offsetPos);
                    mappedByteBuffer = ((FileChannel)readChannel).map(FileChannel.MapMode.READ_ONLY, offsetPos, bytesToBeRead);
                    mappedByteBuffer.get(buf, 0, bytesToBeRead);
                    if (hasReadingLimit && offsetPos + (long)bytesToBeRead >= endPosition + 1L) {
                        long lValidReadingSize = endPosition + 1L - offsetPos;
                        int iValidReadingSize = (int)lValidReadingSize;
                        bufForSearch = new byte[iValidReadingSize];
                        bytesToBeEatByBigBinSearcher = iValidReadingSize;
                        mappedByteBuffer.rewind();
                        mappedByteBuffer.get(bufForSearch, 0, iValidReadingSize);
                    } else {
                        if (bytesToBeRead != actualBufferSize) {
                            bufForSearch = new byte[bytesToBeRead];
                            mappedByteBuffer.flip();
                            mappedByteBuffer.get(bufForSearch);
                        } else {
                            bufForSearch = buf;
                        }
                        bytesToBeEatByBigBinSearcher = bytesToBeRead;
                    }
                    List relPointerList = bbs.searchBigBytes(bufForSearch, searchBytes);
                    for (Integer relPointer : relPointerList) {
                        long absolutePointer = (long)relPointer.intValue() + offsetPos;
                        pointerList.add(absolutePointer);
                    }
                    long bytesRemain = endPosition + 1L - (offsetPos += (long)(bytesToBeEatByBigBinSearcher - byteShiftForSearch));
                    if (listener == null) {
                        listener = this.bigFileProgressListener;
                    }
                    if (listener != null) {
                        float progress = (float)offsetPos / (float)endPosition;
                        listener.onProgress(pointerList, progress, offsetPos, startPosition, endPosition);
                    }
                    if (bytesRemain != (long)byteShiftForSearch) continue;
                    if (listener == null) {
                        listener = this.bigFileProgressListener;
                    }
                    if (listener != null) {
                        float progress = 1.0f;
                        listener.onProgress(pointerList, progress, offsetPos, startPosition, endPosition);
                    }
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (readChannel != null) {
                try {
                    readChannel.close();
                }
                catch (IOException e) {}
            }
        }
        this.sort(pointerList);
        return pointerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> searchPartiallyUsingLegacy(File f, byte[] searchBytes, long startPosition, long maxSizeToRead, BinFileProgressListener listener) {
        ArrayList<Long> pointerList = new ArrayList<Long>();
        this.isLoopInprogress = true;
        BigBinarySearcher bbs = new BigBinarySearcher();
        bbs.setMaxNumOfThreads(this.subThreadSize);
        bbs.setBufferSize(this.subBufferSize);
        boolean hasReadingLimit = maxSizeToRead > 0L;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            long targetFileSize = raf.length();
            if (startPosition < 0L || startPosition > targetFileSize) {
                throw new RuntimeException("StartPos is invalid.");
            }
            long endPosition = hasReadingLimit ? (startPosition + maxSizeToRead > targetFileSize ? targetFileSize - 1L : startPosition + maxSizeToRead - 1L) : targetFileSize - 1L;
            byte[] byteBuf = null;
            long offsetPos = startPosition;
            if (searchBytes.length > this.bufferSize) {
                throw new RuntimeException("The length of the target bytes is less than bufferSize.Please set more bigger bufferSize.");
            }
            int byteShiftForSearch = searchBytes.length - 1;
            while (this.isLoopInprogress) {
                int bytesRead;
                byte[] bufForSearch;
                raf.seek(offsetPos);
                byteBuf = new byte[this.bufferSize];
                int actualBytesRead = raf.read(byteBuf);
                if (hasReadingLimit && offsetPos + (long)actualBytesRead >= endPosition + 1L) {
                    long lValidReadingSize = endPosition + 1L - offsetPos;
                    int iValidReadingSize = (int)lValidReadingSize;
                    bufForSearch = new byte[iValidReadingSize];
                    bytesRead = iValidReadingSize;
                    System.arraycopy(byteBuf, 0, bufForSearch, 0, iValidReadingSize);
                } else {
                    if (actualBytesRead != this.bufferSize) {
                        bufForSearch = new byte[actualBytesRead];
                        System.arraycopy(byteBuf, 0, bufForSearch, 0, actualBytesRead);
                    } else {
                        bufForSearch = byteBuf;
                    }
                    bytesRead = actualBytesRead;
                }
                List relPointerList = bbs.searchBigBytes(bufForSearch, searchBytes);
                for (Integer relPointer : relPointerList) {
                    long absolutePointer = (long)relPointer.intValue() + offsetPos;
                    pointerList.add(absolutePointer);
                }
                long bytesRemain = endPosition + 1L - (offsetPos += (long)(bytesRead - byteShiftForSearch));
                if (listener == null) {
                    listener = this.bigFileProgressListener;
                }
                if (listener != null) {
                    float progress = (float)offsetPos / (float)endPosition;
                    listener.onProgress(pointerList, progress, offsetPos, startPosition, endPosition);
                }
                if (bytesRemain != (long)byteShiftForSearch) continue;
                if (listener == null) {
                    listener = this.bigFileProgressListener;
                }
                if (listener != null) {
                    float progress = 1.0f;
                    listener.onProgress(pointerList, progress, offsetPos, startPosition, endPosition);
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {}
            }
        }
        this.sort(pointerList);
        return pointerList;
    }

    protected void sort(List<Long> list) {
        list.sort(new Comparator<Long>(){

            @Override
            public int compare(Long num1, Long num2) {
                if (num1 > num2) {
                    return 1;
                }
                if (num1 < num2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void stop() {
        this.isLoopInprogress = false;
    }

    public static interface BinFileProgressListener {
        public void onProgress(List<Long> var1, float var2, float var3, float var4, long var5);
    }
}

