/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bigdoc.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.riversun.bigdoc.xml.BasicSAXHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BigXmlReader {
    private final BasicSAXHandler mSaxHandler = new BasicSAXHandler();

    public void read(InputStream is, String encoding, final TagListener listener) {
        this.mSaxHandler.initialize();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, encoding);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            this.mSaxHandler.setTagEventListener(new BasicSAXHandler.TagEventListener(){

                @Override
                public void onTagStarted(String fullTagName, String tagName) {
                    if (listener != null) {
                        listener.onTagStarted(BigXmlReader.this, fullTagName, tagName);
                    }
                }

                @Override
                public void onTagFinished(String fullTagName, String tagName, String value, Attributes atts) {
                    if (listener != null) {
                        listener.onTagFinished(BigXmlReader.this, fullTagName, tagName, value, atts);
                    }
                }
            });
            xmlReader.setContentHandler(this.mSaxHandler);
            InputSource iso = new InputSource(reader);
            xmlReader.parse(iso);
        }
        catch (BasicSAXHandler.BasicSAXHandlerException spf) {
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.mSaxHandler.forceStop();
    }

    public static interface TagListener {
        public void onTagStarted(BigXmlReader var1, String var2, String var3);

        public void onTagFinished(BigXmlReader var1, String var2, String var3, String var4, Attributes var5);
    }
}

