/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bing.client.v5.image_search;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Logger;
import org.riversun.bing.client.v5.image_search.BingImageSearchException;
import org.riversun.bing.client.v5.image_search.http.LiteHttpClient;
import org.riversun.bing.client.v5.image_search.http.LiteHttpClientException;
import org.riversun.bing.client.v5.image_search.model.BingImageSearchRequest;
import org.riversun.bing.client.v5.image_search.model.BingImageSearchResponse;

public class BingImageSearchClient
extends LiteHttpClient {
    private static final Logger LOGGER = Logger.getLogger(BingImageSearchClient.class.getName());
    private final String mApikey;
    private final ObjectMapper mJackson = new ObjectMapper();

    public BingImageSearchClient(String apikey) {
        this.mApikey = apikey;
    }

    public BingImageSearchResponse searchImage(BingImageSearchRequest searchReq) throws BingImageSearchException {
        String responseText;
        LOGGER.fine("searchRequest=" + searchReq);
        this.addHeader("Ocp-Apim-Subscription-Key", this.mApikey);
        this.open("GET", "https://api.cognitive.microsoft.com/bing/v5.0/images/search?" + searchReq.toQueryString());
        try {
            responseText = this.send();
        }
        catch (LiteHttpClientException e1) {
            BingImageSearchException e2 = new BingImageSearchException(e1.getMessage(), e1);
            throw e2;
        }
        BingImageSearchResponse bingResponse = null;
        try {
            bingResponse = (BingImageSearchResponse)this.mJackson.readValue(responseText, BingImageSearchResponse.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bingResponse;
    }
}

