/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bing.client.v5.image_search.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.riversun.bing.client.v5.image_search.http.LiteHttpClientException;

public class LiteHttpClient {
    private static final Logger LOGGER = Logger.getLogger(LiteHttpClient.class.getName());
    private Map<String, String> mHeaders = new LinkedHashMap<String, String>();
    private String mMethod = "POST";
    private String mEndpoint = "";
    private String mUserAgent = null;

    public LiteHttpClient addHeader(String key, String value) {
        this.mHeaders.put(key, value);
        return this;
    }

    public LiteHttpClient setUserAgent(String ua) {
        this.mUserAgent = ua;
        return this;
    }

    public LiteHttpClient open(String method, String url) {
        this.mMethod = method;
        this.mEndpoint = url;
        return this;
    }

    public String send() throws LiteHttpClientException {
        return this.send(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(String sendString) throws LiteHttpClientException {
        LOGGER.fine("sendString=" + sendString);
        URL url = null;
        PrintWriter pw = null;
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        OutputStream os = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        InputStream is = null;
        HttpURLConnection con = null;
        try {
            String line;
            url = new URL(this.mEndpoint);
            con = (HttpURLConnection)url.openConnection();
            con.setDoOutput(true);
            if (this.mUserAgent != null) {
                con.setRequestProperty("User-Agent", this.mUserAgent);
            }
            for (String key : this.mHeaders.keySet()) {
                con.setRequestProperty(key, this.mHeaders.get(key));
            }
            con.setRequestMethod(this.mMethod);
            con.setInstanceFollowRedirects(false);
            con.connect();
            os = con.getOutputStream();
            osw = new OutputStreamWriter(os, "UTF-8");
            bw = new BufferedWriter(osw);
            pw = new PrintWriter(bw);
            if (sendString != null) {
                pw.print(sendString);
            }
            pw.flush();
            is = con.getInputStream();
            isr = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String responseText = sb.toString();
            LOGGER.fine("responseText=" + responseText);
            String string = responseText;
            return string;
        }
        catch (MalformedURLException sb) {
        }
        catch (IOException e) {
            if (con != null) {
                try {
                    int responseCode = con.getResponseCode();
                    if (responseCode >= 500) {
                        String errorMessage = this.getFromStream(con.getInputStream());
                        throw new LiteHttpClientException(e);
                    }
                    String errorMessage = this.getFromStream(con.getErrorStream());
                    throw new LiteHttpClientException(errorMessage, e);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFromStream(InputStream is) {
        BufferedReader br = null;
        InputStreamReader isr = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            isr = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }
}

