/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.bing.client.v5.image_search.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.riversun.string_grabber.StringGrabber;

public class BingImageSearchRequest {
    private final List<Param<?>> mParamList = new ArrayList();
    public Param<String> keyword = new Param<Object>(this, "q", null);
    public Param<Integer> count = new Param<Object>(this, "count", null);
    public Param<Integer> offset = new Param<Object>(this, "offset", null);
    public Param<String> mkt = new Param<Object>(this, "mkt", null);
    public Param<String> safeSearch = new Param<Object>(this, "safeSearch", null);
    public Param<String> size = new Param<Object>(this, "size", null);

    public String toQueryString() {
        StringGrabber sg = new StringGrabber();
        for (Param<?> param : this.mParamList) {
            sg.append(((Param)param).toQueryString());
            sg.append("&");
        }
        sg.removeTail();
        return sg.toString();
    }

    public static class Param<T> {
        private String mQueryKey;
        private T mValue;
        private final BingImageSearchRequest mRequest;

        public Param(BingImageSearchRequest req, String key, T value) {
            req.mParamList.add(this);
            this.mRequest = req;
            this.mQueryKey = key;
            this.mValue = value;
        }

        public BingImageSearchRequest set(T value) {
            this.mValue = value;
            return this.mRequest;
        }

        private String toQueryString() {
            if (this.mValue == null) {
                return "";
            }
            String encoded = String.valueOf(this.mValue);
            try {
                encoded = URLEncoder.encode(String.valueOf(this.mValue), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return this.mQueryKey + "=" + encoded;
        }
    }
}

