/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.riversun.d6.D6Model;
import org.riversun.d6.DBConnCreator;
import org.riversun.d6.DBConnInfo;
import org.riversun.d6.annotation.DBTable;
import org.riversun.d6.core.D6CrudDeleteHelper;
import org.riversun.d6.core.D6CrudInsertHelper;
import org.riversun.d6.core.D6CrudSelectHelper;
import org.riversun.d6.core.D6CrudUpdateHelper;
import org.riversun.d6.core.D6Exception;
import org.riversun.d6.core.D6Inex;
import org.riversun.d6.core.D6Logger;
import org.riversun.d6.core.ModelWrapper;
import org.riversun.d6.core.WhereCondition;

public class D6Crud {
    DBConnInfo mConnInfo;
    String mDbcpPropertyFile;

    public D6Crud(DBConnInfo connInfo) {
        this.mConnInfo = connInfo;
    }

    public D6Crud(String dbcpPropertyFile) {
        this.mDbcpPropertyFile = dbcpPropertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execDelete(Class<? extends D6Model> modelObj) {
        boolean retVal;
        block10: {
            retVal = false;
            D6CrudDeleteHelper dh = new D6CrudDeleteHelper(modelObj);
            String updateSQL = dh.createDeleteAllPreparedSQLStatement();
            this.log("#execDelete model=" + modelObj + " deleteSQL=" + updateSQL);
            Connection conn = this.createConnection();
            PreparedStatement preparedStmt = null;
            conn.setAutoCommit(false);
            preparedStmt = conn.prepareStatement(updateSQL);
            preparedStmt.executeUpdate();
            conn.commit();
            retVal = true;
            try {
                conn.close();
            }
            catch (SQLException e) {
                retVal = false;
                this.loge("#execDelete", e);
            }
            break block10;
            catch (SQLException e) {
                try {
                    this.loge("#execDelete", e);
                    retVal = false;
                }
                catch (Throwable throwable) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        retVal = false;
                        this.loge("#execDelete", e2);
                    }
                    throw throwable;
                }
                try {
                    conn.close();
                }
                catch (SQLException e3) {
                    retVal = false;
                    this.loge("#execDelete", e3);
                }
            }
        }
        return retVal;
    }

    public boolean execDelete(D6Model modelObj) {
        return this.execDelete(new D6Model[]{modelObj});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execDelete(D6Model[] modelObjs) {
        boolean retVal;
        block16: {
            if (modelObjs == null || modelObjs.length == 0) {
                return false;
            }
            retVal = false;
            D6CrudDeleteHelper dh = new D6CrudDeleteHelper(modelObjs[0].getClass());
            String deleteSQL = dh.createDeletePreparedSQLStatement();
            this.log("#execDelete modelObjs=" + modelObjs + " delete SQL=" + deleteSQL);
            Connection conn = this.createConnection();
            PreparedStatement preparedStmt = null;
            conn.setAutoCommit(false);
            preparedStmt = conn.prepareStatement(deleteSQL);
            for (D6Model modelObj : modelObjs) {
                dh.map(modelObj, preparedStmt);
                preparedStmt.executeUpdate();
            }
            conn.commit();
            retVal = true;
            try {
                conn.close();
            }
            catch (SQLException e) {
                retVal = false;
                this.loge("#execDelete", e);
            }
            break block16;
            catch (SQLException e) {
                this.loge("#execDelete", e);
                retVal = false;
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    retVal = false;
                    this.loge("#execDelete", e2);
                }
            }
            catch (D6Exception e2) {
                this.loge("#execDelete", e2);
                retVal = false;
                {
                    catch (Throwable throwable) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            retVal = false;
                            this.loge("#execDelete", e3);
                        }
                        throw throwable;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException e4) {
                    retVal = false;
                    this.loge("#execDelete", e4);
                }
            }
        }
        return retVal;
    }

    public boolean execUpdate(D6Model modelObj) {
        D6Inex includeExcludeColumnNames = null;
        return this.execUpdate(modelObj, includeExcludeColumnNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execUpdate(D6Model modelObj, D6Inex includeExcludeColumnNames) {
        boolean retVal;
        block15: {
            retVal = false;
            if (modelObj == null) {
                return retVal;
            }
            D6CrudUpdateHelper d6CrudUpdateHelper = new D6CrudUpdateHelper(modelObj.getClass());
            String updateSQL = d6CrudUpdateHelper.createUpdatePreparedSQLStatement(includeExcludeColumnNames);
            this.log("#execUpdate updateSQL=" + updateSQL);
            Connection conn = this.createConnection();
            PreparedStatement preparedStmt = null;
            conn.setAutoCommit(false);
            preparedStmt = conn.prepareStatement(updateSQL);
            d6CrudUpdateHelper.map(modelObj, preparedStmt, includeExcludeColumnNames);
            preparedStmt.executeUpdate();
            conn.commit();
            retVal = true;
            try {
                conn.close();
            }
            catch (SQLException e) {
                retVal = false;
                this.loge("#execUpdate", e);
            }
            break block15;
            catch (SQLException e) {
                this.loge("#execUpdate", e);
                retVal = false;
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    retVal = false;
                    this.loge("#execUpdate", e2);
                }
            }
            catch (D6Exception e2) {
                this.loge("#execUpdate", e2);
                retVal = false;
                {
                    catch (Throwable throwable) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            retVal = false;
                            this.loge("#execUpdate", e3);
                        }
                        throw throwable;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException e4) {
                    retVal = false;
                    this.loge("#execUpdate", e4);
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execUpdateByRawSQL(String preparedSQL, Object[] preparedValues) {
        boolean retVal;
        block12: {
            retVal = false;
            Connection conn = this.createConnection();
            PreparedStatement preparedStmt = null;
            conn.setAutoCommit(false);
            preparedStmt = conn.prepareStatement(preparedSQL);
            StringBuilder logSb = new StringBuilder();
            if (preparedValues != null) {
                logSb.append("/ ");
                for (int i = 0; i < preparedValues.length; ++i) {
                    this.setObject(i + 1, preparedStmt, preparedValues[i]);
                    logSb.append("key(" + (i + 1) + ")=" + preparedValues[i]);
                    logSb.append(" ");
                }
            }
            this.log("#execUpdateWithRawSQL SQL=" + preparedSQL + " " + logSb.toString());
            preparedStmt.executeUpdate();
            conn.commit();
            retVal = true;
            try {
                conn.close();
            }
            catch (SQLException e) {
                retVal = false;
                this.loge("#execUpdate", e);
            }
            break block12;
            catch (SQLException e) {
                try {
                    this.loge("#execUpdate", e);
                    retVal = false;
                }
                catch (Throwable throwable) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        retVal = false;
                        this.loge("#execUpdate", e2);
                    }
                    throw throwable;
                }
                try {
                    conn.close();
                }
                catch (SQLException e3) {
                    retVal = false;
                    this.loge("#execUpdate", e3);
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execUpdateByRawSQL(String updateRawSQL) {
        boolean retVal;
        block10: {
            retVal = false;
            this.log("#execUpdateByRawSQL updateRawSQL=" + updateRawSQL);
            Connection conn = this.createConnection();
            Statement stmt = null;
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt.executeUpdate(updateRawSQL);
            conn.commit();
            retVal = true;
            try {
                conn.close();
            }
            catch (SQLException e) {
                retVal = false;
                this.loge("#execUpdateByRawSQL", e);
            }
            break block10;
            catch (SQLException e) {
                try {
                    this.loge("#execUpdateByRawSQL", e);
                    retVal = false;
                }
                catch (Throwable throwable) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        retVal = false;
                        this.loge("#execUpdateByRawSQL", e2);
                    }
                    throw throwable;
                }
                try {
                    conn.close();
                }
                catch (SQLException e3) {
                    retVal = false;
                    this.loge("#execUpdateByRawSQL", e3);
                }
            }
        }
        return retVal;
    }

    public boolean execInsert(D6Model[] modelObjects) {
        D6Inex includeExcludeColumnNames = null;
        return this.execInsert(modelObjects, includeExcludeColumnNames, false);
    }

    public boolean execInsertIgnoreDuplicate(D6Model[] modelObjects) {
        D6Inex includeExcludeColumnNames = null;
        return this.execInsert(modelObjects, includeExcludeColumnNames, true);
    }

    public boolean execInsert(D6Model[] modelObjects, D6Inex includeExcludeColumnNames) {
        boolean ignoreDuplicate = false;
        return this.execInsert(modelObjects, includeExcludeColumnNames, ignoreDuplicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execInsert(D6Model[] modelObjects, D6Inex includeExcludeColumnNames, boolean ignoreDuplicate) {
        this.log("#execInsert");
        boolean retVal = false;
        if (modelObjects == null) {
            return retVal;
        }
        int numOfModelObjects = modelObjects.length;
        if (numOfModelObjects == 0) {
            return retVal;
        }
        D6Model firstModelObject = modelObjects[0];
        D6CrudInsertHelper d6CrudInsertHelper = new D6CrudInsertHelper(firstModelObject.getClass());
        String insertSQL = d6CrudInsertHelper.createInsertPreparedSQLStatement(includeExcludeColumnNames, ignoreDuplicate);
        Connection conn = null;
        PreparedStatement preparedStmt = null;
        conn = this.createConnection();
        conn.setAutoCommit(false);
        preparedStmt = conn.prepareStatement(insertSQL);
        for (int i = 0; i < modelObjects.length; ++i) {
            D6Model model = modelObjects[i];
            d6CrudInsertHelper.map(model, preparedStmt, includeExcludeColumnNames);
            preparedStmt.executeUpdate();
        }
        conn.commit();
        retVal = true;
        if (conn == null) return retVal;
        try {
            conn.close();
            return retVal;
        }
        catch (SQLException e) {
            this.loge("#execInsert", e);
            return false;
        }
        catch (SQLException e) {
            this.loge("#execInsert", e);
            retVal = false;
            if (conn == null) return retVal;
            try {
                conn.close();
                return retVal;
            }
            catch (SQLException e2) {
                this.loge("#execInsert", e2);
                return false;
            }
        }
        catch (D6Exception e2) {
            this.loge("#execInsert", e2);
            retVal = false;
            if (conn == null) return retVal;
            {
                catch (Throwable throwable) {
                    if (conn == null) throw throwable;
                    try {
                        conn.close();
                        throw throwable;
                    }
                    catch (SQLException e3) {
                        this.loge("#execInsert", e3);
                        retVal = false;
                    }
                    throw throwable;
                }
            }
            try {
                conn.close();
                return retVal;
            }
            catch (SQLException e4) {
                this.loge("#execInsert", e4);
                return false;
            }
        }
    }

    public int execSelectCount(Class<? extends D6Model> modelClazz) {
        D6CrudSelectHelper d6CrudSelectHelper = new D6CrudSelectHelper(modelClazz);
        String sqlForSelectCount = d6CrudSelectHelper.getSQLForSelectCount();
        return this.execSelectCount(sqlForSelectCount);
    }

    public int execSelectCount(Class<? extends D6Model> modelClazz, WhereCondition whereCondition) {
        D6CrudSelectHelper d6CrudSelectHelper = new D6CrudSelectHelper(modelClazz);
        String sqlForSelectCount = d6CrudSelectHelper.getSQLForSelectCount();
        String sql = sqlForSelectCount + " " + whereCondition.toSql();
        return this.execSelectCount(sql);
    }

    public int execSelectCount(Class<? extends D6Model> modelClazz, WhereCondition whereCondition, Object[] searchKeys) {
        D6CrudSelectHelper d6CrudSelectHelper = new D6CrudSelectHelper(modelClazz);
        String sqlForSelectCount = d6CrudSelectHelper.getSQLForSelectCount();
        String sql = sqlForSelectCount + " " + whereCondition.toSql();
        return this.execSelectCount(sql, searchKeys);
    }

    public int execSelectCount(String preparedSql) {
        return this.execSelectCount(preparedSql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execSelectCount(String preparedSql, Object[] searchKeys) {
        int retVal;
        block22: {
            this.log("#execSelectCount preparedSql=" + preparedSql + " searchKeys=" + searchKeys);
            retVal = 0;
            PreparedStatement preparedStmt = null;
            ResultSet rs = null;
            Connection conn = this.createConnection();
            preparedStmt = conn.prepareStatement(preparedSql, 1004, 1007);
            StringBuilder logSb = new StringBuilder();
            if (searchKeys != null) {
                logSb.append("/ ");
                for (int i = 0; i < searchKeys.length; ++i) {
                    this.setObject(i + 1, preparedStmt, searchKeys[i]);
                    logSb.append("key(" + (i + 1) + ")=" + searchKeys[i]);
                    logSb.append(" ");
                }
            }
            this.log("#execSelectCount SQL=" + preparedSql + " " + logSb.toString());
            rs = preparedStmt.executeQuery();
            while (rs.next()) {
                retVal = rs.getInt(1);
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (preparedStmt != null) {
                    preparedStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                break block22;
            }
            catch (SQLException e) {
                this.loge("#execSelectCount", e);
            }
            break block22;
            catch (Exception e) {
                try {
                    this.loge("#execSelectCount", e);
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (preparedStmt != null) {
                            preparedStmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        this.loge("#execSelectCount", e2);
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (preparedStmt != null) {
                        preparedStmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e3) {
                    this.loge("#execSelectCount", e3);
                }
            }
        }
        return retVal;
    }

    public Object[] execSelectTable(Class<? extends D6Model> modelClazz) {
        DBTable dbTable = modelClazz.getAnnotation(DBTable.class);
        String dbTableName = dbTable.tableName();
        return this.execSelectTable("SELECT * FROM " + dbTableName, modelClazz);
    }

    public Object[] execSelectTable(Class<? extends D6Model> modelClazz, WhereCondition whereCondition) {
        return this.execSelectTable(modelClazz, whereCondition, null);
    }

    public Object[] execSelectTable(Class<? extends D6Model> modelClazz, WhereCondition whereCondition, Object[] searchKeys) {
        DBTable dbTable = modelClazz.getAnnotation(DBTable.class);
        String dbTableName = dbTable.tableName();
        String preparedSql = "SELECT * FROM " + dbTableName + " " + whereCondition.toSql();
        Map<Class<?>, List<Object>> result = this.execSelectTableWithJoin(preparedSql, searchKeys, modelClazz);
        List<Object> rowList = result.get(modelClazz);
        return this.toArray(rowList, modelClazz);
    }

    public Object[] execSelectTable(String preparedSql, Class<? extends D6Model> modelClazz) {
        return this.execSelectTable(preparedSql, null, modelClazz);
    }

    public Object[] execSelectTable(String preparedSql, Object[] searchKeys, Class<? extends D6Model> modelClazz) {
        Map<Class<?>, List<Object>> result = this.execSelectTableWithJoin(preparedSql, searchKeys, modelClazz);
        List<Object> rowList = result.get(modelClazz);
        return this.toArray(rowList, modelClazz);
    }

    public Map<Class<?>, List<Object>> execSelectTableWithJoin(String preparedSql, Class<? extends D6Model> ... modelClazz) {
        return this.execSelectTableWithJoin(preparedSql, (Object[])null, modelClazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public Map<Class<?>, List<Object>> execSelectTableWithJoin(String preparedSql, Object[] searchKeys, Class<? extends D6Model> ... modelClazz) {
        HashMap resultMap;
        block28: {
            String columnName;
            int i;
            this.log("#execSelectTableWithJoin preparedSql=" + preparedSql + " searchKeys=" + searchKeys + " modelClazz=" + modelClazz);
            resultMap = new HashMap();
            ArrayList<ModelWrapper<? extends D6Model>> modelList = new ArrayList<ModelWrapper<? extends D6Model>>();
            for (int i2 = 0; i2 < modelClazz.length; ++i2) {
                ModelWrapper<? extends D6Model> model = new ModelWrapper<D6Model>(modelClazz[i2]);
                modelList.add(model);
            }
            PreparedStatement preparedStmt = null;
            ResultSet rs = null;
            Connection conn = this.createConnection();
            preparedStmt = conn.prepareStatement(preparedSql, 1004, 1007);
            StringBuilder logSb = new StringBuilder();
            if (searchKeys != null) {
                logSb.append("/ ");
                for (int i3 = 0; i3 < searchKeys.length; ++i3) {
                    Object object = searchKeys[i3];
                    this.setObject(i3 + 1, preparedStmt, object);
                    logSb.append("key(" + (i3 + 1) + ")=" + searchKeys[i3]);
                    logSb.append(" ");
                }
            }
            this.log("#execSelectTableWithJoin SQL=" + preparedSql + " " + logSb.toString());
            rs = preparedStmt.executeQuery();
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int numberOfColumns = rsMetaData.getColumnCount();
            ArrayList<String> columnNameList = new ArrayList<String>();
            for (i = 0; i < numberOfColumns; ++i) {
                columnName = rsMetaData.getColumnName(i + 1);
                columnNameList.add(columnName);
            }
            while (rs.next()) {
                for (i = 0; i < numberOfColumns; ++i) {
                    columnName = (String)columnNameList.get(i);
                    Object value = rs.getObject(i + 1);
                    for (ModelWrapper model : modelList) {
                        model.setValue(columnName, value);
                    }
                }
                for (ModelWrapper model : modelList) {
                    Class<?> modelClazzName = model.getClazz();
                    ArrayList modelObjectList = (ArrayList)resultMap.get(modelClazzName);
                    if (modelObjectList == null) {
                        modelObjectList = new ArrayList();
                        resultMap.put(modelClazzName, modelObjectList);
                    }
                    Object resultModelObject = model.getAsObject();
                    modelObjectList.add(resultModelObject);
                    model.initializeFieldMap();
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (preparedStmt != null) {
                    preparedStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                break block28;
            }
            catch (SQLException e) {
                this.loge("#execSelectTableWithJoin SQLException ", e);
            }
            break block28;
            catch (Exception e) {
                try {
                    this.loge("#execSelectTableWithJoin General ", e);
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (preparedStmt != null) {
                            preparedStmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        this.loge("#execSelectTableWithJoin SQLException ", e2);
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (preparedStmt != null) {
                        preparedStmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e3) {
                    this.loge("#execSelectTableWithJoin SQLException ", e3);
                }
            }
        }
        return resultMap;
    }

    private void setObject(int parameterIndex, PreparedStatement preparedStmt, Object value) throws SQLException {
        preparedStmt.setObject(parameterIndex, value);
    }

    private Object[] toArray(List<Object> objectList, Class<? extends D6Model> modelClazz) {
        if (objectList == null) {
            return (Object[])Array.newInstance(modelClazz, 0);
        }
        Object[] resultObjects = objectList.toArray((Object[])Array.newInstance(modelClazz, 0));
        return resultObjects;
    }

    public Object[] getAsModel(Map<Class<?>, List<Object>> o, Class<? extends D6Model> modelClazz) {
        return this.toArray(o.get(modelClazz), modelClazz);
    }

    private Connection createConnection() {
        if (this.mConnInfo != null) {
            DBConnCreator dbConnCreator = new DBConnCreator(this.mConnInfo);
            Connection conn = dbConnCreator.createDBConnection();
            return conn;
        }
        if (this.mDbcpPropertyFile != null) {
            Properties properties = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.mDbcpPropertyFile);
            try {
                properties.load(is);
                DataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
                Connection conn = ds.getConnection();
                return conn;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public RawCrud getRawCrud() {
        return new RawCrud();
    }

    void log(String msg) {
        D6Logger.log(this.getClass(), msg);
    }

    void loge(String msg, Exception ... e) {
        D6Logger.loge(this.getClass(), msg, e);
    }

    public final class RawCrud {
        public Connection createConnection() {
            return D6Crud.this.createConnection();
        }

        public void setObject(int parameterIndex, PreparedStatement preparedStmt, Object value) throws SQLException {
            D6Crud.this.setObject(parameterIndex, preparedStmt, value);
        }
    }
}

