/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.riversun.d6.D6Model;
import org.riversun.d6.annotation.DBColumn;
import org.riversun.d6.core.D6ModelClassFieldInfo;
import org.riversun.d6.core.ModelClazzColumnNameAndFieldMapper;

public abstract class D6CrudHelperBase {
    final Class<?> mModelClazz;
    final Map<String, D6ModelClassFieldInfo> mColumnNameFieldInfoMap;

    public D6CrudHelperBase(Class<? extends D6Model> modelClazz) {
        this.mModelClazz = modelClazz;
        this.mColumnNameFieldInfoMap = new ModelClazzColumnNameAndFieldMapper(this.mModelClazz).build();
    }

    final D6ModelClassFieldInfo getFieldInfo(String columnName) {
        D6ModelClassFieldInfo fieldInfo = this.mColumnNameFieldInfoMap.get(columnName);
        return fieldInfo;
    }

    final Set<String> getAllColumnNames() {
        Set<String> columnNameSet = this.mColumnNameFieldInfoMap.keySet();
        return new LinkedHashSet<String>(columnNameSet);
    }

    final Set<String> getPrimaryColumnNames() {
        List<DBColumn> primaryKeyColumnList = this.getPrimaryKeyColumnList();
        LinkedHashSet<String> primaryKeyColumnNameSet = new LinkedHashSet<String>();
        for (DBColumn col : primaryKeyColumnList) {
            primaryKeyColumnNameSet.add(col.columnName());
        }
        return primaryKeyColumnNameSet;
    }

    void setValue(int parameterIndex, PreparedStatement preparedStatement, Class<?> fieldType, Object fieldValue) throws Exception {
        block18: {
            try {
                if (fieldType == String.class) {
                    preparedStatement.setString(parameterIndex, (String)fieldValue);
                    break block18;
                }
                if (fieldType == Timestamp.class) {
                    preparedStatement.setTimestamp(parameterIndex, (Timestamp)fieldValue);
                    break block18;
                }
                if (fieldType == Date.class) {
                    preparedStatement.setDate(parameterIndex, (Date)fieldValue);
                    break block18;
                }
                if (fieldType == Time.class) {
                    preparedStatement.setTime(parameterIndex, (Time)fieldValue);
                    break block18;
                }
                if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    if (fieldValue != null) {
                        boolean boolValue = (Boolean)fieldValue;
                        preparedStatement.setInt(parameterIndex, boolValue ? 1 : 0);
                    } else {
                        preparedStatement.setInt(parameterIndex, 0);
                    }
                    break block18;
                }
                if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                    if (fieldValue != null) {
                        preparedStatement.setInt(parameterIndex, (Integer)fieldValue);
                    } else {
                        preparedStatement.setNull(parameterIndex, 4);
                    }
                    break block18;
                }
                if (fieldType == Long.TYPE || fieldType == Long.class) {
                    if (fieldValue != null) {
                        preparedStatement.setLong(parameterIndex, (Long)fieldValue);
                    } else {
                        preparedStatement.setNull(parameterIndex, 4);
                    }
                    break block18;
                }
                if (fieldType == Float.TYPE || fieldType == Float.class) {
                    if (fieldValue != null) {
                        preparedStatement.setFloat(parameterIndex, ((Float)fieldValue).floatValue());
                    } else {
                        preparedStatement.setNull(parameterIndex, 6);
                    }
                    break block18;
                }
                String msg = "Unknown data type. type=" + fieldType + " value=" + fieldValue;
                this.loge(msg, new Exception[0]);
                throw new RuntimeException(msg);
            }
            catch (Exception e) {
                this.loge("#setValue", e);
                throw e;
            }
        }
    }

    final List<Field> getPrimaryKeyFieldList() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Set<String> columnNameSet = this.getAllColumnNames();
        for (String columnName : columnNameSet) {
            D6ModelClassFieldInfo fieldInfo = this.getFieldInfo(columnName);
            Field field = fieldInfo.field;
            DBColumn dbColumn = field.getAnnotation(DBColumn.class);
            if (!dbColumn.isPrimaryKey()) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    final List<DBColumn> getPrimaryKeyColumnList() {
        ArrayList<DBColumn> primaryKeyColumnList = new ArrayList<DBColumn>();
        Set<String> columnNameSet = this.getAllColumnNames();
        for (String columnName : columnNameSet) {
            D6ModelClassFieldInfo fieldInfo = this.getFieldInfo(columnName);
            Field field = fieldInfo.field;
            DBColumn dbColumn = field.getAnnotation(DBColumn.class);
            if (!dbColumn.isPrimaryKey()) continue;
            primaryKeyColumnList.add(dbColumn);
        }
        return primaryKeyColumnList;
    }

    abstract void log(String var1);

    abstract void loge(String var1, Exception ... var2);
}

