/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.riversun.d6.D6Model;
import org.riversun.d6.annotation.DBColumn;
import org.riversun.d6.annotation.DBTable;
import org.riversun.d6.core.D6CrudHelperBase;
import org.riversun.d6.core.D6Exception;
import org.riversun.d6.core.D6Inex;
import org.riversun.d6.core.D6Logger;
import org.riversun.d6.core.D6ModelClassFieldInfo;
import org.riversun.string_grabber.StringGrabber;

public class D6CrudUpdateHelper
extends D6CrudHelperBase {
    public D6CrudUpdateHelper(Class<? extends D6Model> modelClazz) {
        super(modelClazz);
    }

    String createUpdatePreparedSQLStatement(D6Inex includeExcludeColumnNames) {
        Set<String> columnNameSet = this.getAllColumnNames();
        StringGrabber sgSQL = new StringGrabber();
        DBTable table = this.mModelClazz.getAnnotation(DBTable.class);
        String tableName = table.tableName();
        sgSQL.append("UPDATE " + tableName + " SET ");
        if (includeExcludeColumnNames != null) {
            includeExcludeColumnNames.manipulate(columnNameSet);
        }
        for (String columnName : columnNameSet) {
            sgSQL.append(columnName);
            sgSQL.append(" = ?, ");
        }
        if (sgSQL.length() > 2) {
            sgSQL.removeTail(2);
        }
        sgSQL.append(" ");
        sgSQL.append(this.getWhereClause());
        String sql = sgSQL.toString();
        this.log("#createUpdatePreparedSQLStatement sql=" + sql);
        return sql;
    }

    String getWhereClause() {
        StringGrabber sgWhere = new StringGrabber();
        List<Field> primaryKeyFieldList = this.getPrimaryKeyFieldList();
        if (primaryKeyFieldList.size() > 0) {
            sgWhere.append("WHERE ");
            for (Field field : primaryKeyFieldList) {
                DBColumn dbColumn = field.getAnnotation(DBColumn.class);
                sgWhere.append(dbColumn.columnName());
                sgWhere.append(" = ? AND ");
            }
            sgWhere.removeTail(5);
        }
        return sgWhere.toString();
    }

    final void map(D6Model mModelObj, PreparedStatement preparedStatement, D6Inex includeExcludeColumnNames) throws D6Exception {
        this.log("#map obj=" + mModelObj);
        Set<String> columnNameSet = this.getAllColumnNames();
        int parameterIndex = 1;
        ArrayList<String> columnNameList = new ArrayList<String>(columnNameSet);
        List<Field> primaryKeyFieldList = this.getPrimaryKeyFieldList();
        for (Field field : primaryKeyFieldList) {
            DBColumn dbColumn = field.getAnnotation(DBColumn.class);
            String columnName = dbColumn.columnName();
            columnNameList.add(columnName);
        }
        if (includeExcludeColumnNames != null) {
            includeExcludeColumnNames.manipulate(columnNameList);
        }
        for (String columnName : columnNameList) {
            D6ModelClassFieldInfo fieldInfo = this.getFieldInfo(columnName);
            boolean isNullable = fieldInfo.isNullable;
            Field field = fieldInfo.field;
            String fieldName = field.getName();
            Class<?> type = field.getType();
            Object fieldValue = null;
            try {
                fieldValue = field.get(mModelObj);
            }
            catch (IllegalArgumentException e) {
                throw new D6Exception(e);
            }
            catch (IllegalAccessException e) {
                throw new D6Exception(e);
            }
            if (fieldValue == null && !isNullable) {
                throw new D6Exception("D6Error the model object field '" + fieldName + "'(column name is " + columnName + ") should not null." + "Because of constraint of table definition.");
            }
            try {
                this.log("#map idx=" + parameterIndex + " " + columnName + "=" + fieldValue + " (" + type + ")");
                this.setValue(parameterIndex, preparedStatement, type, fieldValue);
            }
            catch (Exception e) {
                throw new D6Exception(e);
            }
            ++parameterIndex;
        }
    }

    @Override
    void log(String msg) {
        D6Logger.log(this.getClass(), msg);
    }

    @Override
    void loge(String msg, Exception ... e) {
        D6Logger.loge(this.getClass(), msg, e);
    }
}

