/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.riversun.d6.annotation.DBColumn;
import org.riversun.d6.core.D6ModelClassFieldInfo;

public class ModelClazzColumnNameAndFieldMapper {
    private final Class<?> mModelClazz;
    private final Map<String, D6ModelClassFieldInfo> mFieldMap;

    public ModelClazzColumnNameAndFieldMapper(Class<?> modelClazz) {
        this.mModelClazz = modelClazz;
        this.mFieldMap = new LinkedHashMap<String, D6ModelClassFieldInfo>();
    }

    public void rebuild(Map<String, D6ModelClassFieldInfo> map) {
        this.build(map);
    }

    public Map<String, D6ModelClassFieldInfo> build() {
        this.build(this.mFieldMap);
        return this.mFieldMap;
    }

    private void build(Map<String, D6ModelClassFieldInfo> refFieldMap) {
        refFieldMap.clear();
        Field[] fields = this.mModelClazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            DBColumn annoColumn = field.getAnnotation(DBColumn.class);
            if (annoColumn == null) continue;
            String columnName = annoColumn.columnName();
            String columnType = annoColumn.columnType();
            if (columnName == null || columnType == null) continue;
            D6ModelClassFieldInfo fieldInfo = new D6ModelClassFieldInfo();
            fieldInfo.field = field;
            fieldInfo.columnName = columnName;
            fieldInfo.columnType = columnType;
            fieldInfo.value = null;
            fieldInfo.isAutoIncrement = annoColumn.isAutoIncrement();
            fieldInfo.isNullable = annoColumn.isNullable();
            fieldInfo.isPrimaryKey = annoColumn.isPrimaryKey();
            fieldInfo.isUnique = annoColumn.isUnique();
            refFieldMap.put(columnName, fieldInfo);
        }
    }
}

