/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import org.riversun.d6.core.D6RuntimeException;
import org.riversun.string_grabber.StringGrabber;

public class WhereCondition {
    private StringGrabber mSgSQL = new StringGrabber();
    private ESqlToken mPreviousToken = ESqlToken.NOTHING;

    public WhereCondition WHERE(WhereCondition whereCondition) {
        this.checkTokenOrderIsCorrect(ESqlToken.WHERE);
        this.mSgSQL.append("(");
        this.mSgSQL.append(whereCondition.toWhereConditionPart());
        this.mSgSQL.append(")");
        return this;
    }

    public WhereCondition AND() {
        this.mSgSQL.append(" AND ");
        this.checkTokenOrderIsCorrect(ESqlToken.CONDITION);
        return this;
    }

    public WhereCondition OR() {
        this.mSgSQL.append(" OR ");
        this.checkTokenOrderIsCorrect(ESqlToken.CONDITION);
        return this;
    }

    public WhereCondition Col(String columnName) {
        this.mSgSQL.append(columnName);
        this.checkTokenOrderIsCorrect(ESqlToken.COLUMN);
        return this;
    }

    public WhereCondition Equals() {
        this.mSgSQL.append("=");
        this.checkTokenOrderIsCorrect(ESqlToken.OPERATOR);
        return this;
    }

    public WhereCondition MoreThan() {
        this.mSgSQL.append(">");
        this.checkTokenOrderIsCorrect(ESqlToken.OPERATOR);
        return this;
    }

    public WhereCondition MoreEqualsThan() {
        this.mSgSQL.append(">=");
        this.checkTokenOrderIsCorrect(ESqlToken.OPERATOR);
        return this;
    }

    public WhereCondition LessThan() {
        this.mSgSQL.append("<");
        this.checkTokenOrderIsCorrect(ESqlToken.OPERATOR);
        return this;
    }

    public WhereCondition LessEqualsThan() {
        this.mSgSQL.append("<=");
        this.checkTokenOrderIsCorrect(ESqlToken.OPERATOR);
        return this;
    }

    public WhereCondition Val(Object val) {
        if ("?".equals(val)) {
            this.mSgSQL.append(" ?");
        } else {
            this.mSgSQL.append("'");
            this.mSgSQL.append(val.toString());
            this.mSgSQL.append("'");
        }
        this.checkTokenOrderIsCorrect(ESqlToken.VALUE);
        return this;
    }

    public WhereCondition ValWildCard() {
        return this.Val("?");
    }

    private void checkTokenOrderIsCorrect(ESqlToken tokenTobeAdded) {
        switch (tokenTobeAdded) {
            case COLUMN: {
                if (this.mPreviousToken == ESqlToken.CONDITION || this.mPreviousToken == ESqlToken.NOTHING) break;
                throw new D6RuntimeException("AND or OR method is required at here. '" + this.mSgSQL.toString() + "'<==error occurred around here.");
            }
            case OPERATOR: {
                if (this.mPreviousToken == ESqlToken.COLUMN) break;
                throw new D6RuntimeException("VALUE is required at here. '" + this.mSgSQL.toString() + "'<==error occurred around here.");
            }
            case VALUE: {
                if (this.mPreviousToken == ESqlToken.OPERATOR) break;
                throw new D6RuntimeException("COLUMN or PROPERTY method is required at here. '" + this.mSgSQL.toString() + "'<==error occurred around here.");
            }
            case CONDITION: {
                if (this.mPreviousToken == ESqlToken.VALUE || this.mPreviousToken == ESqlToken.WHERE) break;
                throw new D6RuntimeException("VALUE is required at here. '" + this.mSgSQL.toString() + "'<==error occurred around here.");
            }
            case WHERE: {
                if (this.mPreviousToken == ESqlToken.CONDITION || this.mPreviousToken == ESqlToken.NOTHING) break;
                throw new D6RuntimeException("CONDITION is required at here. '" + this.mSgSQL.toString() + "'<==error occurred around here.");
            }
        }
        this.mPreviousToken = tokenTobeAdded;
    }

    String toWhereConditionPart() {
        if (this.mPreviousToken != ESqlToken.VALUE && this.mPreviousToken != ESqlToken.WHERE) {
            throw new D6RuntimeException("Where condition is not completed. '" + this.mSgSQL.toString() + "'<==error occurred around here.");
        }
        return this.mSgSQL.toString();
    }

    String toSql() {
        return "WHERE " + this.toWhereConditionPart();
    }

    private static enum ESqlToken {
        COLUMN,
        OPERATOR,
        VALUE,
        CONDITION,
        WHERE,
        NOTHING;

    }
}

