/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Set;
import org.riversun.d6.D6Model;
import org.riversun.d6.annotation.DBTable;
import org.riversun.d6.core.D6CrudHelperBase;
import org.riversun.d6.core.D6Exception;
import org.riversun.d6.core.D6Logger;
import org.riversun.d6.core.D6ModelClassFieldInfo;
import org.riversun.string_grabber.StringGrabber;

public class D6CrudDeleteHelper
extends D6CrudHelperBase {
    public D6CrudDeleteHelper(Class<? extends D6Model> modelClazz) {
        super(modelClazz);
    }

    String createDeleteAllPreparedSQLStatement() {
        StringGrabber sgSQL = new StringGrabber();
        DBTable table = this.mModelClazz.getAnnotation(DBTable.class);
        String tableName = table.tableName();
        sgSQL.append("DELETE FROM " + tableName);
        return sgSQL.toString();
    }

    String createDeletePreparedSQLStatement() {
        Set<String> primaryKeyColumnNameSet = this.getPrimaryColumnNames();
        StringGrabber sgSQL = new StringGrabber();
        DBTable table = this.mModelClazz.getAnnotation(DBTable.class);
        String tableName = table.tableName();
        sgSQL.append("DELETE FROM " + tableName + " WHERE ");
        for (String columnName : primaryKeyColumnNameSet) {
            sgSQL.append(columnName);
            sgSQL.append(" = ?, ");
        }
        if (sgSQL.length() > 2) {
            sgSQL.removeTail(2);
        }
        String sql = sgSQL.toString();
        this.log("#createUpdatePreparedSQLStatement sql=" + sql);
        return sql;
    }

    final void map(D6Model mModelObj, PreparedStatement preparedStatement) throws D6Exception {
        this.log("#map obj=" + mModelObj);
        Set<String> primaryKeyColumnNameSet = this.getPrimaryColumnNames();
        int parameterIndex = 1;
        ArrayList<String> columnNameList = new ArrayList<String>(primaryKeyColumnNameSet);
        for (String columnName : columnNameList) {
            D6ModelClassFieldInfo fieldInfo = this.getFieldInfo(columnName);
            boolean isNullable = fieldInfo.isNullable;
            Field field = fieldInfo.field;
            String fieldName = field.getName();
            Class<?> type = field.getType();
            Object fieldValue = null;
            try {
                fieldValue = field.get(mModelObj);
            }
            catch (IllegalArgumentException e) {
                throw new D6Exception(e);
            }
            catch (IllegalAccessException e) {
                throw new D6Exception(e);
            }
            if (fieldValue == null && !isNullable) {
                throw new D6Exception("D6Error the model object field '" + fieldName + "'(column name is " + columnName + ") should not null.Because of constraint of table definition.");
            }
            try {
                this.log("#map idx=" + parameterIndex + " " + columnName + "=" + fieldValue + " (" + type + ")");
                this.setValue(parameterIndex, preparedStatement, type, fieldValue);
            }
            catch (Exception e) {
                throw new D6Exception(e);
            }
            ++parameterIndex;
        }
    }

    @Override
    void log(String msg) {
        D6Logger.log(this.getClass(), msg);
    }

    @Override
    void loge(String msg, Exception ... e) {
        D6Logger.loge(this.getClass(), msg, e);
    }
}

