/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.Set;
import org.riversun.d6.D6Model;
import org.riversun.d6.annotation.DBTable;
import org.riversun.d6.core.D6CrudHelperBase;
import org.riversun.d6.core.D6Exception;
import org.riversun.d6.core.D6Inex;
import org.riversun.d6.core.D6Logger;
import org.riversun.d6.core.D6ModelClassFieldInfo;
import org.riversun.string_grabber.StringGrabber;

public class D6CrudInsertHelper
extends D6CrudHelperBase {
    public D6CrudInsertHelper(Class<? extends D6Model> modelClazz) {
        super(modelClazz);
    }

    void map(D6Model mModelObj, PreparedStatement preparedStatement, D6Inex includeExcludeColumnNames) throws D6Exception {
        this.log("#map obj=" + mModelObj);
        Set<String> columnNameSet = this.getAllColumnNames();
        int parameterIndex = 1;
        if (includeExcludeColumnNames != null) {
            includeExcludeColumnNames.manipulate(columnNameSet);
        }
        for (String columnName : columnNameSet) {
            D6ModelClassFieldInfo fieldInfo = this.getFieldInfo(columnName);
            boolean isAutoIncrement = fieldInfo.isAutoIncrement;
            boolean isNullable = fieldInfo.isNullable;
            Field field = fieldInfo.field;
            String fieldName = field.getName();
            Class<?> type = field.getType();
            Object fieldValue = null;
            try {
                fieldValue = field.get(mModelObj);
            }
            catch (IllegalArgumentException e) {
                throw new D6Exception(e);
            }
            catch (IllegalAccessException e) {
                throw new D6Exception(e);
            }
            if (fieldValue == null && !isNullable && !isAutoIncrement) {
                throw new D6Exception("D6Error the model object field '" + fieldName + "'(column name is " + columnName + ") should not null.Because of constraint of table definition.");
            }
            if (isAutoIncrement) continue;
            try {
                this.log("#map idx=" + parameterIndex + " " + columnName + "=" + fieldValue + " (" + type + ")");
                this.setValue(parameterIndex, preparedStatement, type, fieldValue);
            }
            catch (Exception e) {
                throw new D6Exception(e);
            }
            ++parameterIndex;
        }
    }

    String createInsertPreparedSQLStatement() {
        D6Inex includeExcludeColumnNames = null;
        boolean ignoreDuplicate = false;
        return this.createInsertPreparedSQLStatement(includeExcludeColumnNames, ignoreDuplicate);
    }

    String createInsertPreparedSQLStatement(D6Inex includeExcludeColumnNames, boolean ignoreDuplicate) {
        Set<String> columnNameSet = this.getAllColumnNames();
        StringGrabber sgSQL = new StringGrabber();
        DBTable table = this.mModelClazz.getAnnotation(DBTable.class);
        String tableName = table.tableName();
        if (ignoreDuplicate) {
            sgSQL.append("INSERT IGNORE INTO " + tableName + " (");
        } else {
            sgSQL.append("INSERT INTO " + tableName + " (");
        }
        StringGrabber sgColumnNames = new StringGrabber();
        StringGrabber sgValues = new StringGrabber();
        if (includeExcludeColumnNames != null) {
            includeExcludeColumnNames.manipulate(columnNameSet);
        }
        for (String columnName : columnNameSet) {
            D6ModelClassFieldInfo fieldInfo = this.getFieldInfo(columnName);
            boolean isAutoIncrement = fieldInfo.isAutoIncrement;
            if (isAutoIncrement) continue;
            sgColumnNames.append(columnName);
            sgColumnNames.append(", ");
            sgValues.append("?");
            sgValues.append(", ");
        }
        if (sgColumnNames.length() > 2) {
            sgColumnNames.removeTail(2);
        }
        if (sgValues.length() > 2) {
            sgValues.removeTail(2);
        }
        sgSQL.append(sgColumnNames.toString());
        sgSQL.append(") ");
        sgSQL.append("VALUES ( ");
        sgSQL.append(sgValues.toString());
        sgSQL.append(" )");
        String sql = sgSQL.toString();
        this.log("#createInsertPreparedSQLStatement sql=" + sql);
        return sql;
    }

    @Override
    void log(String msg) {
        D6Logger.log(this.getClass(), msg);
    }

    @Override
    void loge(String msg, Exception ... e) {
        D6Logger.loge(this.getClass(), msg, e);
    }
}

