/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.riversun.d6.core.D6Logger;

public class D6Inex {
    private final List<String> mIncludeColumnNameList = new ArrayList<String>();
    private final List<String> mExcludeColumnNameList = new ArrayList<String>();

    public D6Inex addIncludeColumn(String columnName) {
        this.mIncludeColumnNameList.add(columnName);
        return this;
    }

    public D6Inex addExcludeColumn(String columnName) {
        this.mExcludeColumnNameList.add(columnName);
        return this;
    }

    public void clear() {
        this.mIncludeColumnNameList.clear();
        this.mExcludeColumnNameList.clear();
    }

    public void manipulate(Collection<String> columnCollection) {
        ArrayList<String> cloneOfColumnCollection = new ArrayList<String>(columnCollection);
        if (this.mIncludeColumnNameList.size() > 0 && this.mExcludeColumnNameList.size() > 0) {
            throw new RuntimeException("You cannot set both include and exclude column names.");
        }
        if (this.mIncludeColumnNameList.size() > 0) {
            this.log("#manipulate include mode includeColumnNameList=" + this.mIncludeColumnNameList);
            for (String columnName : cloneOfColumnCollection) {
                if (this.mIncludeColumnNameList.contains(columnName)) {
                    this.log("#manipulate include mode columnName '" + columnName + "' hold");
                    continue;
                }
                columnCollection.remove(columnName);
            }
        }
        if (this.mExcludeColumnNameList.size() > 0) {
            this.log("#manipulate exclude mode excludeColumnNameList=" + this.mExcludeColumnNameList);
            for (String excludeColumnName : this.mExcludeColumnNameList) {
                if (!cloneOfColumnCollection.contains(excludeColumnName)) continue;
                columnCollection.remove(excludeColumnName);
                this.log("#manipulate exclude mode columnName '" + excludeColumnName + "' skipped");
            }
        }
    }

    void log(String msg) {
        D6Logger.log(this.getClass(), msg);
    }

    void loge(String msg, Exception ... e) {
        D6Logger.loge(this.getClass(), msg, e);
    }
}

