/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.riversun.d6.core.D6Logger;
import org.riversun.d6.core.D6ModelClassFieldInfo;
import org.riversun.d6.core.D6RuntimeException;
import org.riversun.d6.core.ModelClazzColumnNameAndFieldMapper;
import org.riversun.d6.model.Geometry;

class ModelWrapper<T> {
    private final Class<T> modelClazz;
    private final Map<String, D6ModelClassFieldInfo> mFieldMap;

    public ModelWrapper(Class<T> modelClazz) {
        this.modelClazz = modelClazz;
        this.mFieldMap = new ModelClazzColumnNameAndFieldMapper(modelClazz).build();
    }

    public void setValue(String columnName, Object value) {
        D6ModelClassFieldInfo fieldInfo = this.mFieldMap.get(columnName);
        if (fieldInfo != null) {
            fieldInfo.value = value;
        } else {
            String[] parts = columnName.split("__");
            if (parts.length > 0 && this.mFieldMap.containsKey(parts[0])) {
                D6ModelClassFieldInfo compositTypeFieldInfo = this.mFieldMap.get(parts[0]);
                if (compositTypeFieldInfo.valuesForSpecialType == null) {
                    compositTypeFieldInfo.valuesForSpecialType = new ArrayList<Object>();
                }
                compositTypeFieldInfo.valuesForSpecialType.add(value);
            }
        }
    }

    public T getAsObject() {
        try {
            T modelClassObj = this.modelClazz.newInstance();
            Set<String> columnNameSet = this.mFieldMap.keySet();
            for (String columnName : columnNameSet) {
                D6ModelClassFieldInfo fieldInfo = this.mFieldMap.get(columnName);
                Field field = fieldInfo.field;
                Object value = fieldInfo.value;
                if (value != null) {
                    try {
                        field.set(modelClassObj, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        field.set(modelClassObj, value);
                    }
                    catch (IllegalAccessException e) {
                        this.loge("#getAsObject", e);
                    }
                    catch (IllegalArgumentException e) {
                        String name = field.getName();
                        Class<?> type = field.getType();
                        String msg = "The value of '" + columnName + "'=" + value + "(" + value.getClass() + ") couldn't set to variable '" + name + "'(" + type + ")";
                        this.loge("#getAsObject " + msg, new Exception[0]);
                    }
                    continue;
                }
                List<Object> compositObjValues = fieldInfo.valuesForSpecialType;
                if (field.getType() != Geometry.class || compositObjValues == null || compositObjValues.size() <= 1) continue;
                Geometry newGeometryObj = new Geometry();
                newGeometryObj.x = (Double)compositObjValues.get(0);
                newGeometryObj.y = (Double)compositObjValues.get(1);
                field.set(modelClassObj, newGeometryObj);
            }
            return modelClassObj;
        }
        catch (IllegalAccessException e) {
            throw new D6RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new D6RuntimeException("Cannot instanciate model object from '" + this.modelClazz.getName() + "' If you declare '" + this.modelClazz.getName() + "' as inner class, please make it static.");
        }
    }

    public void initializeFieldMap() {
        new ModelClazzColumnNameAndFieldMapper(this.modelClazz).rebuild(this.mFieldMap);
    }

    public Class<?> getClazz() {
        return this.modelClazz;
    }

    void log(String msg) {
        D6Logger.log(this.getClass(), msg);
    }

    void loge(String msg, Exception ... e) {
        D6Logger.loge(this.getClass(), msg, e);
    }
}

