/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.predev;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.riversun.string_grabber.StringGrabber;
import org.riversun.string_grabber.StringGrabberList;

public class D6JavaModelGen4MySQL {
    private static final String JAVA_TYPE_INTEGER = "Integer";
    private static final String JAVA_TYPE_LONG = "Long";
    private static final String JAVA_TYPE_BOOLEAN = "boolean";
    private static final String JAVA_COMPLEX_TYPE_GEOMETRY = "org.riversun.d6.model.Geometry";
    private static final String JAVA_TYPE_TIMESTAMP = "java.sql.Timestamp";
    private static final String JAVA_TYPE_DATE1 = "java.sql.Date";
    private static final String JAVA_TYPE_TIME = "java.sql.Time";
    private static final String JAVA_TYPE_STRING = "String";
    private static final String DQ = "\"";
    private static final boolean IS_DISPLAY_THOSE_OPTIONAL_ON_DB_COLUMN = false;
    private Map<String, String> mTypeMap;

    public String generateModelClass(String mysqlTableDesc) {
        return this.generateModelClass(this.getDatabaseDefinitionFromMySqlTableDescText(mysqlTableDesc));
    }

    public String generateModelClass(DBDefinition dbDefinition) {
        StringGrabber sgOutputModelCalssText = new StringGrabber();
        sgOutputModelCalssText.append("@DBTable(tableName=\"" + dbDefinition.dbTableName + DQ + ")");
        sgOutputModelCalssText.newLine();
        sgOutputModelCalssText.append("public class " + dbDefinition.javaClassName + " implements D6Model");
        sgOutputModelCalssText.newLine();
        sgOutputModelCalssText.append("{");
        sgOutputModelCalssText.newLine();
        int columnCount = dbDefinition.columnList.size();
        for (int i = 0; i < columnCount; ++i) {
            DBColumnDef column = dbDefinition.columnList.get(i);
            StringGrabber sg = new StringGrabber();
            sg.append("columnName=\"" + column.dbColumnName + DQ);
            sg.append(", ");
            sg.append("columnType=\"" + column.dbColumnType + DQ);
            sg.append(", ");
            if (!column.isNullable) {
                sg.append("isNullable=");
                sg.append("false");
                sg.append(", ");
            }
            if (column.isPrimaryKey) {
                sg.append("isPrimaryKey=");
                sg.append("true");
                sg.append(", ");
            }
            if (column.isUnique) {
                sg.append("isUnique=");
                sg.append("true");
                sg.append(", ");
            }
            if (column.isAutoIncrement) {
                sg.append("isAutoIncrement=");
                sg.append("true");
                sg.append(", ");
            }
            sg.removeTail(2);
            String codeLine0 = "@DBColumn(" + sg.toString() + ")";
            String codeLine1 = "public " + column.javaType + " " + column.javaField + ";";
            sgOutputModelCalssText.append(codeLine0);
            sgOutputModelCalssText.newLine();
            sgOutputModelCalssText.append(codeLine1);
            sgOutputModelCalssText.newLine();
            sgOutputModelCalssText.newLine();
        }
        sgOutputModelCalssText.newLine();
        sgOutputModelCalssText.append("}");
        return sgOutputModelCalssText.toString();
    }

    public DBDefinition getDatabaseDefinitionFromMySqlTableDescText(String mySqlTableDescText) {
        boolean descLineNumber = false;
        int fieldLineStartNumber = 4;
        DBDefinition dbDefinition = new DBDefinition();
        StringGrabber sgMysqlTableDescText = new StringGrabber();
        sgMysqlTableDescText.append(mySqlTableDescText);
        StringGrabberList sgList = sgMysqlTableDescText.toSgList();
        dbDefinition.dbTableName = new StringGrabber(sgList.get(0).toString()).getStringEnclosedIn("desc ", ";").get(0).toString();
        dbDefinition.javaClassName = new StringGrabber(this.getCamelCaseFromUnderscoreSeparated(dbDefinition.dbTableName)).replaceFirstToUpperCase().toString();
        dbDefinition.columnList = new ArrayList<DBColumnDef>();
        for (int i = 4; i < sgList.size() - 1; ++i) {
            StringGrabber dbDefLine = sgList.get(i);
            StringGrabberList defList = dbDefLine.getStringEnclosedIn("|", "|");
            DBColumnDef columnDef = new DBColumnDef();
            StringGrabber rawFieldName = defList.get(0).replace(" ", "");
            StringGrabber rawType = defList.get(1).removeHead(1);
            StringGrabber rawNull = defList.get(2).replace(" ", "");
            StringGrabber rawKey = defList.get(3).replace(" ", "");
            StringGrabber rawDefault = defList.get(4).replace(" ", "");
            StringGrabber rawExtra = defList.get(5).replace(" ", "");
            columnDef.dbColumnName = this.removeTailSpace(rawFieldName.toString());
            columnDef.dbColumnType = this.removeTailSpace(rawType.toString());
            columnDef.isNullable = "YES".equals(this.removeTailSpace(rawNull.toString()));
            columnDef.isPrimaryKey = "PRI".equals(this.removeTailSpace(rawKey.toString()));
            columnDef.isUnique = "UNI".equals(this.removeTailSpace(rawKey.toString()));
            columnDef.isAutoIncrement = "auto_increment".equals(this.removeTailSpace(rawExtra.toString()));
            columnDef.javaField = this.getCamelCaseFromUnderscoreSeparated(columnDef.dbColumnName);
            columnDef.javaType = this.getJavaTypeFromMySQLType(columnDef.dbColumnType);
            dbDefinition.columnList.add(columnDef);
        }
        return dbDefinition;
    }

    private String removeTailSpace(String str) {
        int lastIndexOfStr = str.length() - 1;
        if (str.endsWith(" ")) {
            for (int i = lastIndexOfStr; i >= 0; --i) {
                if (str.charAt(i) == ' ') continue;
                int lastIndexToSubstring = i + 1;
                str = str.substring(0, lastIndexToSubstring);
                break;
            }
        }
        return str;
    }

    private String getJavaTypeFromMySQLType(String mySqlType) {
        if (this.mTypeMap == null) {
            this.mTypeMap = new LinkedHashMap<String, String>();
            this.mTypeMap.put("char", JAVA_TYPE_STRING);
            this.mTypeMap.put("varchar", JAVA_TYPE_STRING);
            this.mTypeMap.put("text", JAVA_TYPE_STRING);
            this.mTypeMap.put("longtext", JAVA_TYPE_STRING);
            this.mTypeMap.put("datetime", JAVA_TYPE_TIMESTAMP);
            this.mTypeMap.put("date", JAVA_TYPE_DATE1);
            this.mTypeMap.put("timestamp", JAVA_TYPE_TIMESTAMP);
            this.mTypeMap.put("time", JAVA_TYPE_TIME);
            this.mTypeMap.put("tinyint(1)", JAVA_TYPE_BOOLEAN);
            this.mTypeMap.put("int,unsigned", JAVA_TYPE_LONG);
            this.mTypeMap.put("int", JAVA_TYPE_INTEGER);
            this.mTypeMap.put("mediumint", JAVA_TYPE_INTEGER);
            this.mTypeMap.put("tinyint", JAVA_TYPE_INTEGER);
            this.mTypeMap.put("geometry", JAVA_COMPLEX_TYPE_GEOMETRY);
        }
        for (String typeStr : this.mTypeMap.keySet()) {
            if (!(typeStr.contains(",") ? mySqlType.startsWith(typeStr.split(",")[0]) && mySqlType.contains(typeStr.split(",")[1]) : mySqlType.startsWith(typeStr))) continue;
            return this.mTypeMap.get(typeStr);
        }
        return null;
    }

    private String getCamelCaseFromUnderscoreSeparated(String underScoreSeparatedStr) {
        StringGrabber underScoreSeparatedSg = new StringGrabber(underScoreSeparatedStr);
        StringGrabberList wordBlockList = underScoreSeparatedSg.split("_");
        StringGrabber resultSg = new StringGrabber();
        for (int i = 0; i < wordBlockList.size(); ++i) {
            StringGrabber word = wordBlockList.get(i);
            if (i == 0) {
                resultSg.append(word.toString());
                continue;
            }
            resultSg.append(word.replaceFirstToUpperCase().toString());
        }
        return resultSg.toString();
    }

    public static class DBColumnDef {
        public String dbColumnName;
        public String dbColumnType;
        public String javaField;
        public String javaType;
        public boolean isNullable = true;
        public boolean isPrimaryKey = false;
        public boolean isAutoIncrement = false;
        public boolean isUnique = false;

        public String toString() {
            return "DBColumnDef [dbColumnName=" + this.dbColumnName + ", dbColumnType=" + this.dbColumnType + ", javaField=" + this.javaField + ", javaType=" + this.javaType + ", isNullable=" + this.isNullable + ", isPrimaryKey=" + this.isPrimaryKey + ", isAutoIncrement=" + this.isAutoIncrement + ", isUnique=" + this.isUnique + "]";
        }
    }

    public static class DBDefinition {
        public String dbTableName;
        public String javaClassName;
        public List<DBColumnDef> columnList;
    }
}

