/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.d6.predev;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.riversun.d6.DBConnCreator;
import org.riversun.d6.DBConnInfo;
import org.riversun.d6.core.D6Crud;
import org.riversun.d6.core.D6Logger;
import org.riversun.d6.predev.model.D6ColumnMetaInfo;
import org.riversun.d6.predev.model.D6TableMetaInfo;

public class ShowTableMetaData {
    public static void main(String[] args) {
        D6Logger.setLogging(false);
        ShowTableMetaData obj = new ShowTableMetaData();
        String H2_DB_FILE_PATH_ABS = "file:C:/temp2/sample2";
        String JDBC_DRIVER = "org.h2.Driver";
        String DATABASE_URL = "jdbc:h2:tcp://localhost/file:C:/temp2/sample2";
        String USER = "sa";
        String PASS = "";
        DBConnInfo dbConnInfo = new DBConnInfo();
        dbConnInfo.DBDriver = "org.h2.Driver";
        dbConnInfo.DBUrl = "jdbc:h2:tcp://localhost/file:C:/temp2/sample2";
        dbConnInfo.DBUser = "sa";
        dbConnInfo.DBPassword = "";
        D6Crud crud = new D6Crud(dbConnInfo);
        crud.execUpdateByRawSQL("drop table if exists session");
        String sql = "create table if not exists session(id bigint auto_increment PRIMARY KEY NOT NULL,device_id varchar(255) NOT NULL,session_id varchar(255) NOT NULL,reg_id varchar(255) NOT NULL)";
        crud.execUpdateByRawSQL(sql);
        List<D6TableMetaInfo> tables = obj.getTablesInfo(dbConnInfo);
        for (D6TableMetaInfo tbl : tables) {
            System.out.println("---------------------------------");
            System.out.println("TABLE:" + tbl.tableName);
            List<D6ColumnMetaInfo> colList = tbl.columnList;
            for (D6ColumnMetaInfo col : colList) {
                System.out.println(" " + col.toDefString() + ",");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<D6TableMetaInfo> getTablesInfo(DBConnInfo dbConnInfo) {
        ArrayList<D6TableMetaInfo> retTablesInfo = new ArrayList<D6TableMetaInfo>();
        Connection conn = new DBConnCreator(dbConnInfo).createDBConnection();
        ArrayList<String> tableList = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getTables(null, null, "%", new String[]{"TABLE"});
            try {
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    tableList.add(tableName);
                }
            }
            finally {
                rs.close();
            }
            for (String tableName : tableList) {
                D6ColumnMetaInfo colMeta;
                D6TableMetaInfo tableInfo = new D6TableMetaInfo();
                tableInfo.tableName = tableName;
                LinkedHashMap<String, D6ColumnMetaInfo> colInfoMap = new LinkedHashMap<String, D6ColumnMetaInfo>();
                rs = metaData.getColumns(null, null, tableName, null);
                try {
                    while (rs.next()) {
                        D6ColumnMetaInfo colMeta2 = new D6ColumnMetaInfo();
                        colMeta2.columnName = rs.getString("COLUMN_NAME");
                        colMeta2.typeName = rs.getString("TYPE_NAME");
                        colMeta2.columnSize = rs.getInt("COLUMN_SIZE");
                        colMeta2.isNullable = "YES".equals(rs.getString("IS_NULLABLE"));
                        colMeta2.isAutoIncrement = "YES".equals("IS_AUTOINCREMENT");
                        colMeta2.dataType = rs.getInt("DATA_TYPE");
                        colInfoMap.put(colMeta2.columnName, colMeta2);
                    }
                }
                finally {
                    rs.close();
                }
                rs = metaData.getPrimaryKeys(null, null, tableName);
                try {
                    while (rs.next()) {
                        String columnName = rs.getString("COLUMN_NAME");
                        String pkName = rs.getString("PK_NAME");
                        short primaryKeySequentialIndex = rs.getShort("KEY_SEQ");
                        colMeta = (D6ColumnMetaInfo)colInfoMap.get(columnName);
                        if (colMeta == null) continue;
                        colMeta.pkName = pkName;
                        colMeta.isPrimaryKey = true;
                        colMeta.primaryKeySeqNum = primaryKeySequentialIndex;
                    }
                }
                finally {
                    rs.close();
                }
                try (Statement stmt = conn.createStatement();){
                    rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 0=1");
                    try {
                        ResultSetMetaData rmd = rs.getMetaData();
                        for (int i = 1; i <= rmd.getColumnCount(); ++i) {
                            String columnName = rmd.getColumnName(i);
                            D6ColumnMetaInfo colMeta3 = (D6ColumnMetaInfo)colInfoMap.get(columnName);
                            if (colMeta3 == null) continue;
                            colMeta3.className = rmd.getColumnClassName(i);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                for (String columnName : colInfoMap.keySet()) {
                    colMeta = (D6ColumnMetaInfo)colInfoMap.get(columnName);
                    tableInfo.columnList.add(colMeta);
                }
                retTablesInfo.add(tableInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return retTablesInfo;
    }
}

