/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.exiguous;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.riversun.exiguous.ExifIFDBlock;
import org.riversun.exiguous.ExifIFDField;
import org.riversun.exiguous.ExifTagFinder;

public class ExiguousExifLowLevelDecoder {
    private final int SOI = 65496;
    private final int FOI = 65497;
    private final int APP1_START_CODE = 65505;
    private final int APP0_START_CODE = 65504;
    private final int[] EXIF_DEFINE_CODE = new int[]{69, 120, 105, 102, 0, 0};
    private final int[] BYTE_ORDER_BIGENDIAN = new int[]{77, 77};
    private final int[] BYTE_ORDER_LITTLEENDIAN = new int[]{73, 73};
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    private int m_EndianMode = 1;
    private RandomAccessFile m_TargetRAFile = null;
    private boolean m_IsLogging = false;
    private long m_Ptr_SOI = 0L;
    private long m_Ptr_APP1_Offset = 0L;
    private long m_Ptr_ExifDefineCode = 0L;
    private long m_Ptr_ExifOffset = 0L;
    private long m_Ptr_IFD0Offset = 0L;
    private long m_Ptr_ExifIFDOffset = 0L;
    private long m_Ptr_GPSIFDOffset = 0L;
    private long m_APP1_Segment_Size = 0L;
    private ExifIFDBlock m_IFD0 = null;
    private ExifIFDBlock m_IFD1 = null;
    private ExifIFDBlock m_Exif_IFD = null;
    private ExifIFDBlock m_GPS_IFD = null;
    private final String[] IFD_TAG_TYPE_NAME = new String[]{"-NOTHING-", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DFLOAT"};
    private final int[] IFD_TAG_TYPE_SIZEOF = new int[]{-99999, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    private void openFile(String fileName) {
        try {
            this.m_TargetRAFile = new RandomAccessFile(fileName, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public int getEndianMode() {
        return this.m_EndianMode;
    }

    public boolean read(String fileName) {
        this.openFile(fileName);
        return this.readIFD();
    }

    private boolean readIFD() {
        ExifIFDField GPSIFDPointerFiled;
        ExifIFDField ExifIFDPointerFiled;
        this.log(this.m_Ptr_IFD0Offset, "IFD0 Analyze");
        this.m_Ptr_IFD0Offset = this.getIFD0Offset();
        if (this.m_Ptr_IFD0Offset < 0L) {
            return false;
        }
        this.m_IFD0 = this.IFDAnalyze(this.m_Ptr_IFD0Offset);
        if (this.m_IFD0.NextIFDOffset > 0L) {
            this.log(this.m_IFD0.NextIFDOffset, "IFD1 Analyze");
            this.m_IFD1 = this.IFDAnalyze(this.m_IFD0.NextIFDOffset + this.m_Ptr_ExifOffset);
        }
        if ((ExifIFDPointerFiled = this.m_IFD0.getFieldByName("ExifIFDPointer")) != null) {
            long exifIFDPointer = ExifIFDPointerFiled.LongData;
            this.m_Ptr_ExifIFDOffset = exifIFDPointer + this.m_Ptr_ExifOffset;
            this.log(this.m_Ptr_ExifIFDOffset, "Exif IFD Analyze");
            this.m_Exif_IFD = this.IFDAnalyze(this.m_Ptr_ExifIFDOffset);
        }
        if ((GPSIFDPointerFiled = this.m_IFD0.getFieldByName("GPSInfo")) != null) {
            long GPSIFDPointer = GPSIFDPointerFiled.LongData;
            this.m_Ptr_GPSIFDOffset = GPSIFDPointer + this.m_Ptr_ExifOffset;
            this.log(this.m_Ptr_GPSIFDOffset, "GPS IFD Analyze");
            this.m_GPS_IFD = this.IFDAnalyze(this.m_Ptr_GPSIFDOffset);
        }
        return true;
    }

    private String toHexStr(long val) {
        return "0x" + String.format("%04x", val) + "(" + String.format("%06d", val) + ")";
    }

    private long getIFD0Offset() {
        long retVal = 0L;
        boolean analyzeInProgress = true;
        long fPtr = 0L;
        while (analyzeInProgress) {
            long chunk = this.get2byteAsBigEndian(fPtr);
            if (chunk == 65496L) {
                this.log(fPtr, "This is SOI_ADDRESS");
                this.m_Ptr_SOI = fPtr;
                fPtr += 2L;
                continue;
            }
            if (chunk == 65505L) {
                this.log(fPtr, "This is APP1 start address");
                this.m_Ptr_APP1_Offset = fPtr;
                this.m_APP1_Segment_Size = this.get2byteAsBigEndian(fPtr += 2L);
                this.log(fPtr, "App1 segment length find. Length=" + this.toHexStr(this.m_APP1_Segment_Size) + "bytes");
                int[] rExifDefineCode = this.getMultiByteFromCurrentFile(fPtr += 2L, 6);
                if (!this.compareBetween(rExifDefineCode, this.EXIF_DEFINE_CODE)) {
                    this.log(fPtr, "'Exif' Information Tag in file is incorrect.(>_<)");
                    break;
                }
                this.m_Ptr_ExifOffset = fPtr += 6L;
                this.log(fPtr, "Exif\u3000Zero Offset Pointer find. Offset=" + this.m_Ptr_ExifOffset);
                int[] rByteOrder = this.getMultiByteFromCurrentFile(fPtr, 2);
                if (this.compareBetween(rByteOrder, this.BYTE_ORDER_LITTLEENDIAN)) {
                    this.m_EndianMode = 1;
                    this.log(fPtr, "Byte Order Code find. This data is LITTLE ENDIAN");
                } else if (this.compareBetween(rByteOrder, this.BYTE_ORDER_BIGENDIAN)) {
                    this.m_EndianMode = 0;
                    this.log(fPtr, "Byte Order Code find. This data is BIG ENDIAN");
                } else {
                    this.log(fPtr, "ENDIAN Information is incorrect.(>_<)");
                }
                fPtr += 2L;
                int[] ifd0OffsetData = this.getMultiByteFromCurrentFile(fPtr += 2L, 4);
                long Ptr_IFD0OffsetRelative = this.getLongValue(ifd0OffsetData, this.m_EndianMode);
                retVal = Ptr_IFD0OffsetRelative + this.m_Ptr_ExifOffset;
                this.log(fPtr, "IFD0\u3000Relative Pointer:" + this.toHexStr(Ptr_IFD0OffsetRelative));
                this.log(fPtr, "IFD0\u3000Absolute Pointer:" + this.toHexStr(Ptr_IFD0OffsetRelative + this.m_Ptr_ExifOffset));
                analyzeInProgress = false;
                break;
            }
            if (chunk == 65504L || fPtr > 128L) {
                retVal = -999L;
                return retVal;
            }
            ++fPtr;
        }
        return retVal;
    }

    private ExifIFDBlock IFDAnalyze(long startPtr) {
        ExifIFDBlock ifd = new ExifIFDBlock();
        long fPtr = startPtr;
        int[] rCount = this.getMultiByteFromCurrentFile(fPtr, 2);
        long count = this.getLongValue(rCount, this.m_EndianMode);
        this.log(fPtr += 2L, "IFD Field Count:" + this.toHexStr(count));
        int i = 0;
        while ((long)i < count) {
            int[] fieldByteArray = this.getMultiByteFromCurrentFile(fPtr, 12);
            long tag = this.getLongValue(new int[]{fieldByteArray[0], fieldByteArray[1]}, this.m_EndianMode);
            long type = this.getLongValue(new int[]{fieldByteArray[2], fieldByteArray[3]}, this.m_EndianMode);
            long sizeCount = this.getLongValue(new int[]{fieldByteArray[4], fieldByteArray[5], fieldByteArray[6], fieldByteArray[7]}, this.m_EndianMode);
            int[] dataArray = new int[]{fieldByteArray[8], fieldByteArray[9], fieldByteArray[10], fieldByteArray[11]};
            long data = this.getLongValue(dataArray, this.m_EndianMode);
            long dataSize = sizeCount * (long)this.IFD_TAG_TYPE_SIZEOF[(int)type];
            this.log(fPtr, "IFD Field(" + i + "): Tag=" + ExifTagFinder.getTagName(tag) + "(" + this.toHexStr(tag) + ")" + " TypeName=" + this.IFD_TAG_TYPE_NAME[(int)type] + " Size->" + sizeCount + "*" + this.IFD_TAG_TYPE_SIZEOF[(int)type] + "(byte)=" + dataSize + " data=" + this.toHexStr(data));
            ExifIFDField field = new ExifIFDField();
            field.Tag = tag;
            field.TagName = ExifTagFinder.getTagName(tag);
            field.DataType = type;
            field.SizeCount = sizeCount;
            field.DataSize = dataSize;
            if (dataSize > 4L) {
                long dataPointer = data + this.m_Ptr_ExifOffset;
                field.Data = this.getMultiByteFromCurrentFile(dataPointer, (int)field.DataSize);
                field.LongData = data;
                field.DataOffsetAddress = this.m_Ptr_ExifOffset;
            } else {
                field.LongData = data;
                field.Data = dataArray;
            }
            ifd.addField(field);
            fPtr += 12L;
            ++i;
        }
        int[] rNextIFDOffset = this.getMultiByteFromCurrentFile(fPtr, 2);
        long nextIFDOffset = this.getLongValue(rNextIFDOffset, this.m_EndianMode);
        long absoluteNextIFDOffset = nextIFDOffset + this.m_Ptr_ExifOffset;
        ifd.NextIFDOffset = nextIFDOffset;
        ifd.NextIFDAbsoluteOffset = absoluteNextIFDOffset;
        this.log(fPtr, "IFD Next-IFD Offset=" + this.toHexStr(ifd.NextIFDOffset));
        if (ifd.NextIFDOffset > 0L) {
            this.log(fPtr, "IFD Next-IFD Absolute Offset=" + this.toHexStr(ifd.NextIFDAbsoluteOffset));
        }
        return ifd;
    }

    private boolean compareBetween(int[] src, int[] dest) {
        boolean ret = false;
        if (src != null && dest != null && src.length == dest.length) {
            for (int i = 0; i < src.length; ++i) {
                if (src[i] != dest[i]) {
                    ret = false;
                    break;
                }
                ret = true;
            }
        }
        return ret;
    }

    public long getLongValue(int[] srcByteArray, int endianMode) {
        long retValue = 0L;
        long[] buff = new long[srcByteArray.length];
        int leng = buff.length;
        for (int i = 0; i < leng; ++i) {
            if (endianMode == 0) {
                retValue += (long)srcByteArray[i] * (long)Math.pow(256.0, leng - (i + 1));
            }
            if (endianMode != 1) continue;
            retValue += (long)srcByteArray[i] * (long)Math.pow(256.0, i);
        }
        return retValue;
    }

    private long get1byte(long startPos) {
        long ret = 0L;
        long byte1 = 0L;
        ret = byte1 = (long)this.getMultiByteFromCurrentFile(startPos, 1)[0];
        return ret;
    }

    private long get2byteAsBigEndian(long startPos) {
        long ret = 0L;
        long firstByte = this.get1byte(startPos);
        long secondByte = this.get1byte(startPos + 1L);
        ret = firstByte * 256L + secondByte;
        return ret;
    }

    public int[] getMultiByteFromCurrentFile(long startPos, int len) {
        int[] ret = new int[len];
        byte[] byteArray = new byte[len];
        this.seek(startPos);
        try {
            this.m_TargetRAFile.readFully(byteArray, 0, len);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < len; ++i) {
            ret[i] = byteArray[i] & 0xFF;
        }
        byteArray = null;
        return ret;
    }

    private void seek(long position) {
        try {
            this.m_TargetRAFile.seek(position);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ExifIFDBlock getIFD0() {
        return this.m_IFD0;
    }

    public ExifIFDBlock getIFD1() {
        return this.m_IFD1;
    }

    public ExifIFDBlock getExif_IFD() {
        return this.m_Exif_IFD;
    }

    public ExifIFDBlock getGPS_IFD() {
        return this.m_GPS_IFD;
    }

    public void setLogging(boolean isLogging) {
        this.m_IsLogging = isLogging;
    }

    private void log(long fpos, String text) {
        if (this.m_IsLogging) {
            System.out.println(this.toHexStr(fpos) + ":" + text);
        }
    }
}

