/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.exiguous;

import org.riversun.exiguous.ExifIFDBlock;
import org.riversun.exiguous.ExifIFDField;
import org.riversun.exiguous.ExifInfo;
import org.riversun.exiguous.ExiguousExifLowLevelDecoder;

public class ExiguousExifReader {
    private boolean mIsLogging = false;
    private ExiguousExifLowLevelDecoder mLowLevelDecoder = new ExiguousExifLowLevelDecoder();

    public void setLogging(boolean loggingEnabled) {
        this.mIsLogging = loggingEnabled;
    }

    public void read(String fileName, ExifInfo exifInfo) {
        this.mLowLevelDecoder.setLogging(this.mIsLogging);
        boolean fileReadSuccessFlag = this.mLowLevelDecoder.read(fileName);
        if (fileReadSuccessFlag) {
            ExifIFDField MakerNoteField;
            int endianMode = this.mLowLevelDecoder.getEndianMode();
            ExifIFDBlock IFD0 = this.mLowLevelDecoder.getIFD0();
            ExifIFDBlock IFD1 = this.mLowLevelDecoder.getIFD1();
            ExifIFDBlock exif_IFD = this.mLowLevelDecoder.getExif_IFD();
            ExifIFDBlock gps_IFD = this.mLowLevelDecoder.getGPS_IFD();
            String maker = IFD0.getFieldByName("Make").getStringData();
            String model = IFD0.getFieldByName("Model").getStringData();
            String dateTime = IFD0.getFieldByName("DateTime").getStringData();
            if (exif_IFD != null) {
                String exifVersion = exif_IFD.getFieldByName("ExifVersion").getStringData();
                int[] rExposureTime = exif_IFD.getFieldByName((String)"ExposureTime").Data;
                long bET1 = this.getLongValue(rExposureTime, 0L, 4, endianMode);
                long bET2 = this.getLongValue(rExposureTime, 4L, 4, endianMode);
                float exposureTime = (float)bET1 / (float)bET2;
                int[] rFValue = exif_IFD.getFieldByName((String)"FNumber").Data;
                long bFV1 = this.getLongValue(rFValue, 0L, 4, endianMode);
                long bFV2 = this.getLongValue(rFValue, 4L, 4, endianMode);
                float fValue = (float)bFV1 / (float)bFV2;
                int[] rWidth = exif_IFD.getFieldByName("ExifImageWidth").getData();
                int imageWidth = (int)this.getLongValue(rWidth, 0L, 4, endianMode);
                int[] rHeight = exif_IFD.getFieldByName("ExifImageHeight").getData();
                int imageHeight = (int)this.getLongValue(rHeight, 0L, 4, endianMode);
                exifInfo.setEnabled(true);
                exifInfo.setMaker(maker);
                exifInfo.setModel(model);
                exifInfo.setDateTime(dateTime);
                exifInfo.setExposureTime(exposureTime);
                exifInfo.setExifVersion(exifVersion);
                exifInfo.setFValue(fValue);
                exifInfo.setImageWidth(imageWidth);
                exifInfo.setImageHeight(imageHeight);
            }
            if (gps_IFD != null) {
                String GPSIfdVersion = "";
                if (gps_IFD.getField("0x0000") != null) {
                    int[] rGpsifd_version = gps_IFD.getField((String)"0x0000").Data;
                    for (int i = 0; i < rGpsifd_version.length; ++i) {
                        GPSIfdVersion = GPSIfdVersion + String.valueOf(rGpsifd_version[i]) + ".";
                    }
                    GPSIfdVersion = GPSIfdVersion.substring(0, GPSIfdVersion.length() - 1);
                }
                int[] rGpslatitude_ref = gps_IFD.getField((String)"0x0001").Data;
                long lGpslatitude_ref = this.getLongValue(rGpslatitude_ref, 0L, 4, 1);
                String GPSLatitudeRef = String.valueOf((char)lGpslatitude_ref);
                int[] rGpslatitude = gps_IFD.getField((String)"0x0002").Data;
                long gps_lat_DD = this.getLongValue(rGpslatitude, 0L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lat_DD1 = this.getLongValue(rGpslatitude, 4L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lat_MM = this.getLongValue(rGpslatitude, 8L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lat_MM1 = this.getLongValue(rGpslatitude, 12L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lat_SS0 = this.getLongValue(rGpslatitude, 16L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lat_SS1 = this.getLongValue(rGpslatitude, 20L, 4, this.mLowLevelDecoder.getEndianMode());
                double latitude0 = (double)gps_lat_DD / (double)gps_lat_DD1;
                double latitude1 = (double)gps_lat_MM / (double)gps_lat_MM1 / 60.0;
                double latitude2 = (double)gps_lat_SS0 / (double)gps_lat_SS1 / 3600.0;
                double GPSLatitude = latitude0 + latitude1 + latitude2;
                String DD_lat = Long.toString(gps_lat_DD / gps_lat_DD1);
                double dMM_lat = (double)gps_lat_MM / (double)gps_lat_MM1;
                int iMM_lat = (int)dMM_lat;
                double dSS_lat = (dMM_lat - (double)iMM_lat) * 60.0 + (double)gps_lat_SS0 / (double)gps_lat_SS1;
                String MM_lat = Integer.toString(iMM_lat);
                String DDMMSSSSS_lat = DD_lat + ":" + MM_lat + ":" + String.format("%3.3f", dSS_lat) + "";
                exifInfo.setGpsLatitudeDDMMSSsss(DDMMSSSSS_lat);
                int[] rGpslongitude_ref = gps_IFD.getField((String)"0x0003").Data;
                long lGpslongitude_ref = this.getLongValue(rGpslongitude_ref, 0L, 4, 1);
                String GPSLongitudeRef = String.valueOf((char)lGpslongitude_ref);
                int[] gps_longitude = gps_IFD.getField((String)"0x0004").Data;
                long gps_lng_DD = this.getLongValue(gps_longitude, 0L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lng_DD1 = this.getLongValue(gps_longitude, 4L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lng_MM = this.getLongValue(gps_longitude, 8L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lng_MM1 = this.getLongValue(gps_longitude, 12L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lng_SS0 = this.getLongValue(gps_longitude, 16L, 4, this.mLowLevelDecoder.getEndianMode());
                long gps_lng_SS1 = this.getLongValue(gps_longitude, 20L, 4, this.mLowLevelDecoder.getEndianMode());
                double longitude0 = (double)gps_lng_DD / (double)gps_lng_DD1;
                double longitude1 = (double)gps_lng_MM / (double)gps_lng_MM1 / 60.0;
                double longitude2 = (double)gps_lng_SS0 / (double)gps_lng_SS1 / 3600.0;
                double GPSLongitude = longitude0 + longitude1 + longitude2;
                String DD_lng = Long.toString(gps_lng_DD / gps_lng_DD1);
                double dMM_lng = (double)gps_lng_MM / (double)gps_lng_MM1;
                int iMM_lng = (int)dMM_lng;
                double dSS_lng = (dMM_lng - (double)iMM_lng) * 60.0 + (double)gps_lng_SS0 / (double)gps_lng_SS1;
                String MM_lng = Integer.toString(iMM_lng);
                String DDMMSSSSS_lng = DD_lng + ":" + MM_lng + ":" + String.format("%3.3f", dSS_lng) + "";
                exifInfo.setGpsLongitudeDDMMSSsss(DDMMSSSSS_lng);
                exifInfo.setGpsIFDVersion(GPSIfdVersion);
                exifInfo.setGpsLatitude(GPSLatitude);
                exifInfo.setGpsLatitudeRef(GPSLatitudeRef);
                exifInfo.setGpsLongitude(GPSLongitude);
                exifInfo.setGpsLongitudeRef(GPSLongitudeRef);
                if (gps_IFD.getField("0x0011") != null) {
                    int[] rGPSImageDirection = gps_IFD.getField((String)"0x0011").Data;
                    long direction0 = this.getLongValue(rGPSImageDirection, 0L, 4, this.mLowLevelDecoder.getEndianMode());
                    long direction1 = this.getLongValue(rGPSImageDirection, 4L, 4, this.mLowLevelDecoder.getEndianMode());
                    exifInfo.setGpsImageDirection((float)direction0 / (float)direction1);
                }
            }
            if (exif_IFD != null && (MakerNoteField = exif_IFD.getFieldByName("MakerNote")) != null) {
                exifInfo.setMakerNote(MakerNoteField.Data);
            }
        } else {
            exifInfo.setEnabled(false);
        }
    }

    public int getEndianMode() {
        return this.mLowLevelDecoder.getEndianMode();
    }

    private long getLongValue(int[] data, long startPos, int len, int endian) {
        long longValue = 0L;
        for (int i = 0; i < len; ++i) {
            if (endian == 1) {
                longValue += (long)data[(int)(startPos + (long)i)] * (long)Math.pow(256.0, i);
                continue;
            }
            if (endian != 0) continue;
            longValue += (long)data[(int)(startPos + (long)len - (long)(i + 1))] * (long)Math.pow(256.0, i);
        }
        return longValue;
    }
}

