/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.exiguous;

import java.util.Arrays;
import org.riversun.exiguous.ExifIFDBlock;
import org.riversun.exiguous.ExifIFDField;
import org.riversun.exiguous.ExifTagFinder;

public class ExiguousMakernoteDecoder {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    private int m_EndianMode = 1;
    private final int[] IFD_TAG_TYPE_SIZEOF = new int[]{-99999, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public ExiguousMakernoteDecoder(int endianMode) {
        this.m_EndianMode = endianMode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ExifIFDBlock analyzeMakerNote(int[] rMakerNote) {
        ExifIFDBlock ifd = new ExifIFDBlock();
        int ptr = 0;
        int ifdCount = rMakerNote[(ptr += 12) + 0] + rMakerNote[ptr + 1] * 16;
        ptr += 2;
        int makerNoteLength = rMakerNote.length;
        int j = 0;
        while (true) {
            block5: {
                ExifIFDField field;
                block4: {
                    long dataOrOffsetValue;
                    int[] dataArray;
                    block2: {
                        int dataPointer;
                        long tag;
                        block3: {
                            if (j >= ifdCount) {
                                return ifd;
                            }
                            int[] fieldByteArray = Arrays.copyOfRange(rMakerNote, ptr, ptr + 12);
                            tag = this.getLongValue(new int[]{fieldByteArray[0], fieldByteArray[1]}, this.m_EndianMode);
                            long type = this.getLongValue(new int[]{fieldByteArray[2], fieldByteArray[3]}, this.m_EndianMode);
                            long sizeCount = this.getLongValue(new int[]{fieldByteArray[4], fieldByteArray[5], fieldByteArray[6], fieldByteArray[7]}, this.m_EndianMode);
                            dataArray = new int[]{fieldByteArray[8], fieldByteArray[9], fieldByteArray[10], fieldByteArray[11]};
                            dataOrOffsetValue = this.getLongValue(dataArray, this.m_EndianMode);
                            long dataSize = sizeCount * (long)this.IFD_TAG_TYPE_SIZEOF[(int)type];
                            field = new ExifIFDField();
                            field.Tag = tag;
                            field.TagName = ExifTagFinder.getTagName(tag);
                            field.DataType = type;
                            field.SizeCount = sizeCount;
                            field.DataSize = dataSize;
                            if (dataSize <= 4L) break block2;
                            dataPointer = (int)dataOrOffsetValue;
                            if ((long)dataPointer + field.DataSize > (long)makerNoteLength) break block3;
                            field.Data = Arrays.copyOfRange(rMakerNote, dataPointer, (int)((long)dataPointer + field.DataSize));
                            field.LongData = dataOrOffsetValue;
                            field.DataOffsetAddress = dataPointer;
                            break block4;
                        }
                        System.err.println("Makernote is incorrect. tag=" + ExiguousMakernoteDecoder.toHex(tag) + " tagName=" + field.TagName + "dataOffset(start)=" + dataPointer + " dataEnd(end)=" + ((long)dataPointer + field.DataSize) + " makerNoteLeng=" + makerNoteLength);
                        break block5;
                    }
                    field.LongData = dataOrOffsetValue;
                    field.Data = dataArray;
                }
                ifd.addField(field);
                ptr += 12;
            }
            ++j;
        }
    }

    private static String toHex(long val) {
        return "0x" + String.format("%04x", val);
    }

    public long getLongValue(int[] srcByteArray, int endianMode) {
        long retValue = 0L;
        long[] buff = new long[srcByteArray.length];
        int leng = buff.length;
        for (int i = 0; i < leng; ++i) {
            if (endianMode == 0) {
                retValue += (long)srcByteArray[i] * (long)Math.pow(256.0, leng - (i + 1));
            }
            if (endianMode != 1) continue;
            retValue += (long)srcByteArray[i] * (long)Math.pow(256.0, i);
        }
        return retValue;
    }
}

