/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.ml.fakedatamaker;

import org.riversun.ml.fakedatamaker.AttributeValue;

public class AttributeNumeric {
    public double minValue;
    public double maxValue;
    public double coefficient;
    public ComputeMethod computeMethod;

    public AttributeNumeric(double minValue, double maxValue, ComputeMethod computeMethod, double coefficient) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.coefficient = coefficient;
        this.computeMethod = computeMethod;
    }

    public AttributeNumericValue getRandomNumeric() {
        double generatedNumericValue = Math.random() * (this.maxValue - this.minValue) + this.minValue;
        double _coefficient = 1.0;
        switch (this.computeMethod) {
            case NORMAL: {
                _coefficient = generatedNumericValue * this.coefficient;
                break;
            }
            case SQRT: {
                _coefficient = Math.sqrt(generatedNumericValue) * this.coefficient;
                break;
            }
            case LOG10: {
                _coefficient = Math.log10(generatedNumericValue) * this.coefficient;
            }
        }
        AttributeNumericValue _numericValue = new AttributeNumericValue(generatedNumericValue, _coefficient);
        return _numericValue;
    }

    public static class AttributeNumericValue
    implements AttributeValue {
        public double numericValue;
        public double coefficient;

        public AttributeNumericValue(double numericValue, double coefficient) {
            this.numericValue = numericValue;
            this.coefficient = coefficient;
        }
    }

    public static enum ComputeMethod {
        NORMAL,
        SQRT,
        LOG10;

    }
}

