/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.ml.fakedatamaker;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.riversun.file_grabber.TextFileWriter;
import org.riversun.ml.fakedatamaker.Attribute;
import org.riversun.ml.fakedatamaker.AttributeCheck;
import org.riversun.ml.fakedatamaker.AttributeNominal;
import org.riversun.ml.fakedatamaker.AttributeNumeric;
import org.riversun.ml.fakedatamaker.AttributeValue;

public class RegInstanceGenerator {
    private List<Attribute> attrs = new ArrayList<Attribute>();
    private DataRuleCompliantListener compliantListener = new DataRuleCompliantListener(){

        @Override
        public boolean isCompliant(AttributeCheck valueMap) {
            return true;
        }
    };

    public RegInstanceGenerator attr(Attribute attr) {
        this.attrs.add(attr);
        return this;
    }

    private String generateCsvRandomValues(double baseValue) {
        return this.generateCsvRandomValues(baseValue, 0.0);
    }

    private String toCsvLabels(String resultLabel) {
        StringBuilder sb = new StringBuilder();
        for (Attribute attr : this.attrs) {
            sb.append(attr.label);
            sb.append(",");
        }
        sb.append(resultLabel);
        return sb.toString();
    }

    public String generateCSV(int numOfLines) {
        return this.generateCSV(numOfLines, "target", 1.0);
    }

    public String generateCSV(int numOfLines, String targetLabel, double targetInitialValue) {
        return this.generateCSV(numOfLines, targetLabel, targetInitialValue, 0.0, true, true);
    }

    public String generateCSV(int numOfLines, String targetLabel, double targetInitialValue, double valueVolatility, boolean withHeader, boolean withId) {
        StringBuilder sb = new StringBuilder();
        if (withHeader) {
            if (withId) {
                sb.append("id,");
            }
            sb.append(this.toCsvLabels(targetLabel));
            sb.append("\n");
        }
        for (int i = 0; i < numOfLines; ++i) {
            if (withId) {
                sb.append(i).append(",");
            }
            sb.append(this.generateCsvRandomValues(targetInitialValue, valueVolatility));
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setDataRuleCompliantListener(DataRuleCompliantListener listener) {
        this.compliantListener = listener;
    }

    public String generateCsvRandomValues(double baseValue, double volatility) {
        LinkedHashMap<String, AttributeValue> attributeValues = new LinkedHashMap<String, AttributeValue>();
        StringBuilder sb = new StringBuilder();
        double computedValue = 0.0;
        do {
            computedValue = baseValue + volatility * Math.random() * baseValue;
            sb.setLength(0);
            for (Attribute attr : this.attrs) {
                if (attr.isNominal) {
                    AttributeNominal randomNominal = attr.generateRandomNominal();
                    sb.append(randomNominal.name);
                    sb.append(",");
                    computedValue *= randomNominal.coefficient;
                    attributeValues.put(attr.label, randomNominal);
                    continue;
                }
                AttributeNumeric.AttributeNumericValue randomNumeric = attr.generateRandomNumeric();
                sb.append((int)randomNumeric.numericValue);
                sb.append(",");
                computedValue *= randomNumeric.coefficient;
                attributeValues.put(attr.label, randomNumeric);
            }
        } while (!this.compliantListener.isCompliant(new AttributeCheck(attributeValues)));
        sb.append((int)computedValue);
        return sb.toString();
    }

    public void saveAsUTF8(File file, String string) {
        this.save(file, "UTF-8", string);
    }

    public void save(File file, String encoding, String string) {
        TextFileWriter w = new TextFileWriter();
        w.writeText(file, string, encoding, false);
    }

    public void saveAsUTF8WithBom(File file, String encoding, String string) {
        TextFileWriter w = new TextFileWriter();
        w.writeTextAsUTF8WithBOM(file, string, false);
    }

    public static interface DataRuleCompliantListener {
        public boolean isCompliant(AttributeCheck var1);
    }
}

