/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.ml.fakedatamaker;

import java.io.File;
import org.riversun.ml.fakedatamaker.Attribute;
import org.riversun.ml.fakedatamaker.AttributeCheck;
import org.riversun.ml.fakedatamaker.AttributeNominal;
import org.riversun.ml.fakedatamaker.AttributeNumeric;
import org.riversun.ml.fakedatamaker.RegInstanceGenerator;

class _ExampleEn {
    _ExampleEn() {
    }

    public static void main(String[] args) {
        double basePrice = 10.0;
        Attribute acGenryo = new Attribute("material", new AttributeNominal("Diamond", 20.0), new AttributeNominal("Platinum", 15.0), new AttributeNominal("Gold", 10.0), new AttributeNominal("Silver", 3.0));
        Attribute brand = new Attribute("brand", new AttributeNominal("WorldTopBrand", 8.0), new AttributeNominal("FamouseBrand", 4.5), new AttributeNominal("NationalBrand", 2.0), new AttributeNominal("NoBrand", 1.0));
        Attribute shop = new Attribute("shop", new AttributeNominal("BrandStore", 1.7), new AttributeNominal("DepartmentStore", 1.5), new AttributeNominal("MassRetailer", 1.2), new AttributeNominal("DiscountStore", 1.1));
        Attribute shape = new Attribute("shape", new AttributeNominal("Ring", 1.1), new AttributeNominal("Neckless", 1.07), new AttributeNominal("Earrings", 1.05), new AttributeNominal("Brooch", 1.05), new AttributeNominal("Brace", 1.15));
        Attribute weightg = new Attribute("weight", new AttributeNumeric(10.0, 60.0, AttributeNumeric.ComputeMethod.LOG10, 1.0));
        RegInstanceGenerator instance = new RegInstanceGenerator().attr(acGenryo).attr(shape).attr(weightg).attr(brand).attr(shop);
        instance.setDataRuleCompliantListener(new RegInstanceGenerator.DataRuleCompliantListener(){

            @Override
            public boolean isCompliant(AttributeCheck check) {
                if (check.nominalEquals("brand", "NoBrand") && check.nominalEquals("shop", "BrandStore")) {
                    return false;
                }
                if (check.nominalEquals("brand", "WorldTopBrand") && check.nominalEquals("shop", "DiscountStore") || check.nominalEquals("shop", "MassRetailer")) {
                    return false;
                }
                return !check.nominalEquals("brand", "FamouseBrand") || !check.nominalEquals("shop", "DiscountStore");
            }
        });
        int numOfLines = 20;
        String generatedCSV = instance.generateCSV(numOfLines, "price", basePrice);
        System.out.println(generatedCSV);
        instance.saveAsUTF8(new File("c:/temp/price.csv"), generatedCSV);
    }
}

