/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.ml.fakedatamaker;

import java.io.File;
import org.riversun.ml.fakedatamaker.Attribute;
import org.riversun.ml.fakedatamaker.AttributeCheck;
import org.riversun.ml.fakedatamaker.AttributeNominal;
import org.riversun.ml.fakedatamaker.AttributeNumeric;
import org.riversun.ml.fakedatamaker.RegInstanceGenerator;

class _ExampleJa {
    _ExampleJa() {
    }

    public static void main(String[] args) {
        double basePrice = 1000.0;
        Attribute acGenryo = new Attribute("material", new AttributeNominal("\u30c0\u30a4\u30a2", 20.0), new AttributeNominal("\u30d7\u30e9\u30c1\u30ca", 15.0), new AttributeNominal("\u30b4\u30fc\u30eb\u30c9", 10.0), new AttributeNominal("\u30b7\u30eb\u30d0\u30fc", 3.0));
        Attribute brand = new Attribute("brand", new AttributeNominal("\u6d77\u5916\u8d85\u6709\u540d\u30d6\u30e9\u30f3\u30c9", 8.0), new AttributeNominal("\u6d77\u5916\u6709\u540d\u30d6\u30e9\u30f3\u30c9", 4.5), new AttributeNominal("\u56fd\u5185\u6709\u540d\u30d6\u30e9\u30f3\u30c9", 2.0), new AttributeNominal("\u30ce\u30fc\u30d6\u30e9\u30f3\u30c9", 1.0));
        Attribute shop = new Attribute("shop", new AttributeNominal("\u76f4\u55b6\u5e97", 1.7), new AttributeNominal("\u767e\u8ca8\u5e97", 1.5), new AttributeNominal("\u91cf\u8ca9\u5e97", 1.2), new AttributeNominal("\u6fc0\u5b89\u30b7\u30e7\u30c3\u30d7", 1.1));
        Attribute shape = new Attribute("shape", new AttributeNominal("\u6307\u8f2a", 1.1), new AttributeNominal("\u30cd\u30c3\u30af\u30ec\u30b9", 1.07), new AttributeNominal("\u30a4\u30a2\u30ea\u30f3\u30b0", 1.05), new AttributeNominal("\u30d6\u30ed\u30fc\u30c1", 1.05), new AttributeNominal("\u30d6\u30ec\u30b9\u30ec\u30c3\u30c8", 1.15));
        Attribute weightg = new Attribute("weight", new AttributeNumeric(10.0, 60.0, AttributeNumeric.ComputeMethod.LOG10, 1.0));
        RegInstanceGenerator instance = new RegInstanceGenerator().attr(acGenryo).attr(shape).attr(weightg).attr(brand).attr(shop);
        instance.setDataRuleCompliantListener(new RegInstanceGenerator.DataRuleCompliantListener(){

            @Override
            public boolean isCompliant(AttributeCheck check) {
                if (check.nominalEquals("brand", "\u30ce\u30fc\u30d6\u30e9\u30f3\u30c9") && check.nominalEquals("shop", "\u76f4\u55b6\u5e97")) {
                    return false;
                }
                if (check.nominalEquals("brand", "\u6d77\u5916\u8d85\u6709\u540d\u30d6\u30e9\u30f3\u30c9") && check.nominalEquals("shop", "\u6fc0\u5b89\u30b7\u30e7\u30c3\u30d7") || check.nominalEquals("shop", "\u91cf\u8ca9\u5e97")) {
                    return false;
                }
                return !check.nominalEquals("brand", "\u6d77\u5916\u6709\u540d\u30d6\u30e9\u30f3\u30c9") || !check.nominalEquals("shop", "\u6fc0\u5b89\u30b7\u30e7\u30c3\u30d7");
            }
        });
        int numOfLines = 500;
        String generatedCSV = instance.generateCSV(numOfLines, "price", basePrice);
        System.out.println(generatedCSV);
        instance.saveAsUTF8WithBom(new File("c:/temp/gem_price_ja.csv"), "UTF-8", generatedCSV);
    }
}

