/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.file_grabber;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileReader {
    public String readTextCharByChar(File file) throws IOException {
        return this.readTextCharByChar(file, null);
    }

    public String readTextCharByChar(File file, String charset) throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        return this.readTextCharByChar(fis, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextCharByChar(InputStream is, String charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = this.isNotBlank(charset) ? new InputStreamReader(is, charset) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            int iChar = br.read();
            while (iChar != -1) {
                sb.append((char)iChar);
                iChar = br.read();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public String readText(File file) throws IOException {
        return this.readText(file, null);
    }

    public String readText(File file, String charset) throws IOException {
        return this.readTextCharByChar(file, charset);
    }

    public List<String> readTextAsList(File file) throws IOException {
        return this.readTextAsList(file, null);
    }

    public List<String> readTextAsList(File file, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return this.readTextAsList(fis, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readTextAsList(InputStream is, String charset) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = this.isNotBlank(charset) ? new InputStreamReader(is, charset) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                lineList.add(line);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lineList;
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.isEmpty();
    }
}

