/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.file_grabber;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileWriter {
    private static final String UTF_8 = "UTF-8";
    private final String NEW_LINE = System.getProperty("line.separator");

    public boolean writeText(File file, String text, boolean append) {
        return this.writeText(file, text, UTF_8, append);
    }

    public boolean writeLines(File file, List<String> lines, boolean append) {
        return this.writeLines(file, lines, UTF_8, append);
    }

    public boolean writeLines(File file, List<String> lines, String charset, boolean append) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append(this.NEW_LINE);
        }
        return this.writeText(file, sb.toString(), charset, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeText(File file, String text, String charset, boolean append) {
        if (file == null) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, append);
            this.writeTextToStream(fos, text, charset);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTextToStream(OutputStream os, String text, String charset) {
        if (os == null) {
            return false;
        }
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(os, charset);
            bw = new BufferedWriter(osw);
            bw.write(text);
            bw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

