/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.file_grabber;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextFile {
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static String readCharByChar(File file) throws IOException {
        return TextFile.readCharByChar(file, null);
    }

    public static String readCharByChar(File file, String charset) throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        return TextFile.readCharByChar(fis, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readCharByChar(InputStream is, String charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = TextFile.isNotBlank(charset) ? new InputStreamReader(is, charset) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            int iChar = br.read();
            while (iChar != -1) {
                sb.append((char)iChar);
                iChar = br.read();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static String read(File file) throws IOException {
        return TextFile.read(file, null);
    }

    public static String read(File file, String charset) throws IOException {
        return TextFile.readCharByChar(file, charset);
    }

    public static String read(InputStream is, String charset) throws IOException {
        return TextFile.readCharByChar(is, charset);
    }

    public static String readFromResource(String fileName) throws IOException {
        return TextFile.readFromResource(fileName, StandardCharsets.UTF_8.toString());
    }

    public static String readFromResource(String fileName, String charset) throws IOException {
        InputStream is = TextFile.class.getClassLoader().getResourceAsStream(fileName);
        return TextFile.read(is, charset);
    }

    public static String readFromResource(Class<?> clazz, String fileName, String charset) throws IOException {
        InputStream is = clazz.getResourceAsStream(fileName);
        return TextFile.read(is, charset);
    }

    public static List<String> readFromResourceAsList(Class<?> clazz, String fileName, String charset, String newLine) throws IOException {
        String text = TextFile.readFromResource(clazz, fileName, charset);
        String[] lines = text.split(newLine);
        return Arrays.asList(lines);
    }

    public static List<String> readAsList(File file) throws IOException {
        return TextFile.readAsList(file, null);
    }

    public static List<String> readAsListWithRange(File file, int beginLineNum, int endLineNum) throws IOException {
        return TextFile.readAsListWithRange(file, null, beginLineNum, endLineNum);
    }

    public static List<String> readAsList(File file, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return TextFile.readAsList(fis, charset);
    }

    public static List<String> readAsListWithRange(File file, String charset, int beginLineNum, int endLineNum) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return TextFile.readAsListWithRange(fis, charset, beginLineNum, endLineNum);
    }

    public static List<String> readAsList(InputStream is, String charset) throws IOException {
        return TextFile.readAsListWithRange(is, charset, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAsListWithRange(InputStream is, String charset, int beginLineNum, int endLineNum) throws IOException {
        long crrReadingLineNum = 0L;
        ArrayList<String> lineList = new ArrayList<String>();
        if (beginLineNum < 0) {
            beginLineNum = 0;
        }
        if (beginLineNum > endLineNum) {
            return lineList;
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = TextFile.isNotBlank(charset) ? new InputStreamReader(is, charset) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                boolean isSkip = false;
                boolean isFinish = false;
                isSkip = (long)beginLineNum > crrReadingLineNum;
                isFinish = crrReadingLineNum > (long)endLineNum && endLineNum >= 0;
                if (isFinish) {
                    break;
                }
                if (!isSkip) {
                    lineList.add(line);
                }
                ++crrReadingLineNum;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lineList;
    }

    public static boolean write(File file, String text) {
        return TextFile.write(file, text, StandardCharsets.UTF_8.toString(), false);
    }

    public static boolean write(File file, String text, boolean append) {
        return TextFile.write(file, text, StandardCharsets.UTF_8.toString(), append);
    }

    public static boolean writeLines(File file, List<String> lines, boolean append) {
        return TextFile.writeLines(file, lines, StandardCharsets.UTF_8.toString(), append);
    }

    public static boolean writeLines(File file, List<String> lines, String charset, boolean append) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line);
            sb.append(NEW_LINE);
        }
        return TextFile.write(file, sb.toString(), charset, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(File file, String text, String charset, boolean append) {
        if (file == null) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, append);
            TextFile.writeToStream(fos, text, charset);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToStream(OutputStream os, String text, String charset) {
        if (os == null) {
            return false;
        }
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(os, charset);
            bw = new BufferedWriter(osw);
            bw.write(text);
            bw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeAsUTF8WithBOM(File file, String text, boolean append) {
        if (file == null) {
            return false;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, append);
            try {
                fos.write(239);
                fos.write(187);
                fos.write(191);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TextFile.writeToStream(fos, text, StandardCharsets.UTF_8.toString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static boolean isNotBlank(String str) {
        return str != null && !str.isEmpty();
    }
}

