/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.file_grabber;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextFileReader {
    public String readTextCharByChar(File file) throws IOException {
        return this.readTextCharByChar(file, null);
    }

    public String readTextCharByChar(File file, String charset) throws IOException {
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        return this.readTextCharByChar(fis, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextCharByChar(InputStream is, String charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = this.isNotBlank(charset) ? new InputStreamReader(is, charset) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            int iChar = br.read();
            while (iChar != -1) {
                sb.append((char)iChar);
                iChar = br.read();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public String readText(File file) throws IOException {
        return this.readText(file, null);
    }

    public String readText(File file, String charset) throws IOException {
        return this.readTextCharByChar(file, charset);
    }

    public String readText(InputStream is, String charset) throws IOException {
        return this.readTextCharByChar(is, charset);
    }

    public String readTextFromResourceAsUTF8(String fileName) throws IOException {
        return this.readTextFromResource(fileName, StandardCharsets.UTF_8.toString());
    }

    public String readTextFromResource(String fileName, String charset) throws IOException {
        InputStream is = TextFileReader.class.getClassLoader().getResourceAsStream(fileName);
        return this.readText(is, charset);
    }

    public String readTextFromResource(Class<?> clazz, String fileName, String charset) throws IOException {
        InputStream is = clazz.getResourceAsStream(fileName);
        return this.readText(is, charset);
    }

    public List<String> readTextAsListFromResource(Class<?> clazz, String fileName, String charset, String newLine) throws IOException {
        String text = this.readTextFromResource(clazz, fileName, charset);
        String[] lines = text.split(newLine);
        return Arrays.asList(lines);
    }

    public List<String> readTextAsList(File file) throws IOException {
        return this.readTextAsList(file, null);
    }

    public List<String> readTextAsListWithRange(File file, int beginLineNum, int endLineNum) throws IOException {
        return this.readTextAsListWithRange(file, null, beginLineNum, endLineNum);
    }

    public List<String> readTextAsList(File file, String charset) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return this.readTextAsList(fis, charset);
    }

    public List<String> readTextAsListWithRange(File file, String charset, int beginLineNum, int endLineNum) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return this.readTextAsListWithRange(fis, charset, beginLineNum, endLineNum);
    }

    public List<String> readTextAsList(InputStream is, String charset) throws IOException {
        return this.readTextAsListWithRange(is, charset, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readTextAsListWithRange(InputStream is, String charset, int beginLineNum, int endLineNum) throws IOException {
        long crrReadingLineNum = 0L;
        ArrayList<String> lineList = new ArrayList<String>();
        if (beginLineNum < 0) {
            beginLineNum = 0;
        }
        if (beginLineNum > endLineNum) {
            return lineList;
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = this.isNotBlank(charset) ? new InputStreamReader(is, charset) : new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                boolean isSkip = false;
                boolean isFinish = false;
                isSkip = (long)beginLineNum > crrReadingLineNum;
                isFinish = crrReadingLineNum > (long)endLineNum && endLineNum >= 0;
                if (isFinish) {
                    break;
                }
                if (!isSkip) {
                    lineList.add(line);
                }
                ++crrReadingLineNum;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lineList;
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.isEmpty();
    }
}

