/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.riversun.oauth2.google.OAuthBaseServlet;
import org.riversun.oauth2.google.OAuthCommon;
import org.riversun.oauth2.google.OAuthHandler;

public abstract class OAuthCallbackServlet
extends OAuthBaseServlet {
    private static final Logger LOGGER = Logger.getLogger(OAuthCallbackServlet.class.getName());
    private final Map<String, String> mTempRefreshTokenMap = new ConcurrentHashMap<String, String>();

    protected abstract String getAuthRedirectUrl();

    protected void saveRefreshTokenFor(String userId, String refreshToken) {
        LOGGER.fine("userId=" + userId + " refreshToken=" + refreshToken);
        this.mTempRefreshTokenMap.put(userId, refreshToken);
    }

    protected String loadRefreshTokenFor(String userId) {
        String storedRefreshToken = this.mTempRefreshTokenMap.get(userId);
        String refreshToken = storedRefreshToken == null ? "dummy_refresh_token" : storedRefreshToken;
        LOGGER.fine("userId=" + userId + " refreshToken=" + refreshToken);
        return refreshToken;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.fine("");
        String code = this.asString(req, "code");
        String stateToken = this.asString(req, "state");
        if (code != null && stateToken != null) {
            LOGGER.fine("code=" + code);
            String storedStateToken = (String)this.sessionScope(req, "org.riversun.goauth.session_key_oauth2_state_token");
            if (storedStateToken == null || !stateToken.equals(storedStateToken)) {
                LOGGER.warning("stateToken not matched!");
                resp.sendError(403, "OAuth2 state token is invalid. stateToken=" + stateToken + " storedStateToken=" + storedStateToken);
                return;
            }
        } else {
            LOGGER.warning("The parameter 'code' or 'state' not found!");
            resp.sendError(403, "Invalid parameters code=" + code + " state=" + stateToken);
            return;
        }
        LOGGER.fine("stateToken matched state=" + stateToken);
        this.sessionScope(req, "org.riversun.goauth.session_key_oauth2_state_token", null);
        OAuthHandler oh = new OAuthHandler(this.getAuthRedirectUrl());
        GoogleTokenResponse tokenResponse = oh.getTokenResponseFromCode(code);
        LOGGER.fine("Received tokenResponse=" + tokenResponse);
        LOGGER.fine("Received refresh_token=" + tokenResponse.getRefreshToken());
        GoogleIdToken idToken = oh.getIdToken(tokenResponse);
        if (idToken == null) {
            throw new ServletException((Throwable)new Exception("IdToken verification error"));
        }
        GoogleIdToken.Payload payload = idToken.getPayload();
        this.sessionScope(req, "org.riversun.goauth.session_key_id_token", idToken);
        String userId = payload.getSubject();
        this.sessionScope(req, "org.riversun.goauth.session_key_payload_sub", userId);
        LOGGER.fine("TOKEN_INFO subject(unique userId)=" + userId);
        String _refreshToken = tokenResponse.getRefreshToken();
        if (_refreshToken != null) {
            this.saveRefreshTokenFor(userId, _refreshToken);
        }
        LOGGER.fine("use refresh token refreshToken=" + tokenResponse.getRefreshToken());
        String accessToken = tokenResponse.getAccessToken();
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(OAuthCommon.HTTP_TRANSPORT).setJsonFactory(OAuthCommon.JSON_FACTORY).setClientSecrets(OAuthCommon.getClientSecrets()).build().setAccessToken(accessToken).setRefreshToken(this.loadRefreshTokenFor(userId));
        this.sessionScope(req, "org.riversun.goauth.session_key_credential", credential);
        this.sessionScope(req, "org.riversun.goauth.session_key_oauth2_done", Boolean.TRUE);
        String redirectPath = (String)this.sessionScope(req, "org.riversun.goauth.session_key_auth_requst_url");
        this.sessionScope(req, "org.riversun.goauth.session_key_auth_requst_url", null);
        if (redirectPath == null || redirectPath.isEmpty()) {
            redirectPath = req.getContextPath() + "/";
        }
        LOGGER.fine("redirectPath=" + redirectPath);
        resp.sendRedirect(redirectPath);
    }

    protected final void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendNotSupportedError(req, resp);
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendNotSupportedError(req, resp);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.sendNotSupportedError(req, resp);
    }

    private final void sendNotSupportedError(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(403, "Not supported");
    }
}

