/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

final class OAuthCommon {
    private static final Logger LOGGER = Logger.getLogger(OAuthCommon.class.getName());
    public static final List<String> SCOPES = new CopyOnWriteArrayList<String>();
    public static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();

    OAuthCommon() {
    }

    public static final GoogleClientSecrets getClientSecrets() throws IOException {
        InputStream is = OAuthCommon.class.getResourceAsStream("/client_secret.json");
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)JSON_FACTORY, (Reader)new InputStreamReader(is));
        return clientSecrets;
    }

    public static final GoogleAuthorizationCodeFlow createFlow() throws IOException {
        return new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, JSON_FACTORY, OAuthCommon.getClientSecrets(), SCOPES).build();
    }
}

