/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.http.HttpResponseException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.riversun.oauth2.google.OAuthCommon;
import org.riversun.oauth2.google.OAuthHandler;

public abstract class OAuthFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(OAuthFilter.class.getName());
    private static final String OAUTH2_SCOPE_OPENID = "openid";

    public final void init(FilterConfig config) throws ServletException {
        LOGGER.fine("");
        OAuthCommon.SCOPES.clear();
        OAuthCommon.SCOPES.add(OAUTH2_SCOPE_OPENID);
        OAuthCommon.SCOPES.addAll(this.getScopes());
    }

    protected abstract String getAuthRedirectUrl();

    protected abstract List<String> getScopes();

    protected boolean isAutoHandleRefreshTokenRevocation() {
        return true;
    }

    protected boolean isAuthenticateEverytime() {
        return true;
    }

    protected boolean isForceHttps() {
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        LOGGER.fine("");
        OAuthHandler oh = new OAuthHandler(this.getAuthRedirectUrl()).setForceUseHttps(this.isForceHttps());
        if (this.isOAuth2Done(request, response)) {
            LOGGER.fine("OAuth2 already passed");
            try {
                chain.doFilter(request, response);
            }
            catch (HttpResponseException e) {
                if (oh.isRevocationRelatedException((Exception)((Object)e))) {
                    LOGGER.warning("Refresh token not found or revoked.Force show authorization page.");
                    boolean forceApprovalPrompt = true;
                    oh.doOAuth2Flow(request, response, true);
                }
            }
        } else {
            boolean forceApprovalPrompt = false;
            oh.doOAuth2Flow(request, response, false);
        }
    }

    private boolean isOAuth2Done(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        HttpSession session = req.getSession();
        boolean isOAuth2Done = session.getAttribute("org.riversun.goauth.session_key_oauth2_done") != null;
        LOGGER.fine("isOAuth2Done=" + isOAuth2Done);
        if (isOAuth2Done) {
            if (this.isAuthenticateEverytime()) {
                session.setAttribute("org.riversun.goauth.session_key_oauth2_done", null);
            }
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

