/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.riversun.oauth2.google.OAuthCommon;

public final class OAuthHandler {
    private static final Logger LOGGER = Logger.getLogger(OAuthHandler.class.getName());
    private final String mRedirectUrl;
    private boolean mForceUseHttps = false;

    public OAuthHandler(String redirectUrl) {
        this.mRedirectUrl = redirectUrl;
    }

    public OAuthHandler setForceUseHttps(boolean enabled) {
        this.mForceUseHttps = enabled;
        return this;
    }

    public void doOAuth2Flow(ServletRequest request, ServletResponse response, boolean forceApprovalPrompt) throws IOException, ServletException {
        LOGGER.fine("");
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String stateToken = this.generateStateToken();
        String currentUrl = this.getCurrentUrl(req, this.mForceUseHttps);
        LOGGER.fine("SET SESSION stateToken=" + stateToken);
        req.getSession().setAttribute("org.riversun.goauth.session_key_oauth2_state_token", (Object)stateToken);
        LOGGER.fine("SET SESSION currentUrl=" + currentUrl);
        req.getSession().setAttribute("org.riversun.goauth.session_key_auth_requst_url", (Object)currentUrl);
        GoogleAuthorizationCodeRequestUrl authorizationCodeRequestUrl = OAuthCommon.createFlow().newAuthorizationUrl().setAccessType("offline").setRedirectUri(this.mRedirectUrl).setState(stateToken);
        if (forceApprovalPrompt) {
            authorizationCodeRequestUrl.setApprovalPrompt("force");
        }
        String authUrl = authorizationCodeRequestUrl.toString();
        LOGGER.fine("redirect to auth url=" + authorizationCodeRequestUrl.toString());
        resp.sendRedirect(authUrl);
    }

    private final String generateStateToken() {
        String stateToken = new BigInteger(130, new SecureRandom()).toString(32);
        return stateToken;
    }

    private String getCurrentUrl(HttpServletRequest req, boolean forceUseHttps) {
        String scheme = forceUseHttps ? "https" : req.getScheme();
        int currentPort = req.getServerPort();
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(req.getServerName());
        if (currentPort != 80 && currentPort != 443) {
            sb.append(":");
            sb.append(currentPort);
        }
        sb.append(req.getRequestURI());
        if (req.getQueryString() != null && !req.getQueryString().isEmpty()) {
            sb.append("?");
            sb.append(req.getQueryString());
        }
        String currentUrl = sb.toString();
        return currentUrl;
    }

    public GoogleTokenResponse getTokenResponseFromCode(String code) {
        LOGGER.fine("code=" + code);
        GoogleTokenResponse tokenResponse = null;
        try {
            GoogleAuthorizationCodeFlow flow = OAuthCommon.createFlow();
            LOGGER.fine("execute newTokenRequest(" + code + ")");
            tokenResponse = flow.newTokenRequest(code).setRedirectUri(this.mRedirectUrl).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warning("Please check whether you are reloading on the OAuth callback servlet");
            e.printStackTrace();
        }
        return tokenResponse;
    }

    public GoogleIdToken getIdToken(GoogleTokenResponse tokenResponse) {
        LOGGER.fine("");
        if (tokenResponse == null) {
            return null;
        }
        GoogleIdTokenVerifier idTokenVerifier = new GoogleIdTokenVerifier(OAuthCommon.HTTP_TRANSPORT, OAuthCommon.JSON_FACTORY);
        GoogleIdToken idToken = null;
        try {
            idToken = GoogleIdToken.parse((JsonFactory)OAuthCommon.JSON_FACTORY, (String)tokenResponse.getIdToken());
            if (!idTokenVerifier.verify(idToken)) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return idToken;
    }

    public boolean isRevocationRelatedException(Exception e) {
        return e instanceof TokenResponseException ? ((TokenResponseException)e).getContent().contains("invalid_grant") : e instanceof HttpResponseException && ((HttpResponseException)((Object)e)).getContent().contains("Invalid Credentials");
    }
}

