/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.riversun.oauth2.google.OAuthSecrets;

public final class OAuthUtil {
    private static final Logger LOGGER = Logger.getLogger(OAuthUtil.class.getName());
    static final List<String> SCOPES = new CopyOnWriteArrayList<String>();
    static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();

    static final GoogleAuthorizationCodeFlow createFlow() throws IOException {
        return new GoogleAuthorizationCodeFlow.Builder(HTTP_TRANSPORT, JSON_FACTORY, OAuthSecrets.getClientSecrets(), SCOPES).build();
    }

    public static final GoogleCredential createCredential(String accessToken, String refreshToken) throws IOException {
        LOGGER.fine("accessToken=" + accessToken + " refreshToken=" + refreshToken);
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(HTTP_TRANSPORT).setJsonFactory(JSON_FACTORY).setClientSecrets(OAuthSecrets.getClientSecrets()).build().setAccessToken(accessToken).setRefreshToken(refreshToken);
        return credential;
    }
}

