/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OAuthBaseServlet
extends HttpServlet {
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CORS cors = ((Object)((Object)this)).getClass().getAnnotation(CORS.class);
        if (cors != null) {
            String allowFrom = cors.allowFrom();
            if (allowFrom != null && !allowFrom.isEmpty()) {
                this.setAccessControlAllowOrigin(resp, allowFrom);
            }
            boolean allowCredentials = cors.allowCredentials();
            this.setAccessControlAllowCredentials(resp, allowCredentials);
        }
        super.service(req, resp);
    }

    protected String asString(HttpServletRequest req, String parameterName) {
        return req.getParameter(parameterName);
    }

    public String asString(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = req.getReader();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    protected Long asLong(HttpServletRequest req, String parameterName) {
        Long retVal = null;
        try {
            retVal = Long.parseLong(this.asString(req, parameterName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    protected Integer asInteger(HttpServletRequest req, String parameterName) {
        Integer retVal = null;
        try {
            retVal = Integer.parseInt(this.asString(req, parameterName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    protected void requestScope(HttpServletRequest req, String name, Object value) {
        req.setAttribute(name, value);
    }

    protected Object requestScope(HttpServletRequest req, String name) {
        return req.getAttribute(name);
    }

    protected void sessionScope(HttpServletRequest req, String name, Serializable value) {
        HttpSession session = req.getSession(true);
        if (value != null) {
            session.setAttribute(name, (Object)value);
        } else {
            session.removeAttribute(name);
        }
    }

    protected Object sessionScope(HttpServletRequest req, String name) {
        HttpSession session = req.getSession(true);
        return session.getAttribute(name);
    }

    public void setContentTypeTo_JSON_UTF8(HttpServletResponse resp) {
        this.setContentType(resp, "application/json; charset=UTF-8");
    }

    protected String getRemoteHost(HttpServletRequest req) {
        return req.getRemoteHost();
    }

    public void setContentTypeTo_HTML_UTF8(HttpServletResponse resp) {
        this.setContentType(resp, "text/html; charset=UTF-8");
    }

    public void setContentTypeTo_XML_UTF8(HttpServletResponse resp) {
        this.setContentType(resp, "application/xml; charset=UTF-8");
    }

    protected void dispatch(HttpServletRequest req, HttpServletResponse resp, String fowardToPath) throws ServletException, IOException {
        RequestDispatcher dispatcher = req.getRequestDispatcher(fowardToPath);
        dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
    }

    public void setContentType(HttpServletResponse resp, String contentType) {
        resp.setContentType(contentType);
    }

    protected void returnAsText(HttpServletResponse resp, String text) throws ServletException, IOException {
        PrintWriter out = resp.getWriter();
        out.println(text);
        out.close();
    }

    protected void setAccessControlAllowOrigin(HttpServletResponse resp, String value) {
        resp.addHeader("Access-Control-Allow-Origin", value);
        resp.addHeader("Access-Control-Allow-Headers", "Content-Type");
    }

    protected void setAccessControlAllowCredentials(HttpServletResponse resp, boolean enabled) {
        if (enabled) {
            resp.addHeader("Access-Control-Allow-Credentials", String.valueOf(enabled));
        }
    }

    protected void redirect(HttpServletResponse resp, String redirectToPath) throws ServletException, IOException {
        String ret = "";
        if (redirectToPath.startsWith("/")) {
            ret = this.removeHead(redirectToPath, 1);
        }
        resp.sendRedirect(ret);
    }

    private String removeHead(String str, int cnt) {
        StringBuilder sb = new StringBuilder(str);
        try {
            sb.delete(0, cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    protected void returnAsHtml(HttpServletResponse resp, String html) throws ServletException, IOException {
        this.setContentTypeTo_HTML_UTF8(resp);
        PrintWriter out = resp.getWriter();
        out.println(html);
        out.close();
    }

    protected void returnAsJS(HttpServletResponse resp, String html) throws ServletException, IOException {
        this.setContentType(resp, "application/javascript; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println(html);
        out.close();
    }

    protected void returnNothing(HttpServletResponse resp) throws IOException {
        this.setContentTypeTo_JSON_UTF8(resp);
        PrintWriter out = resp.getWriter();
        out.close();
    }

    protected void addCookie(HttpServletResponse resp, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(true);
        resp.addCookie(cookie);
    }

    public String getCookie(HttpServletRequest req, String name) {
        String result = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                result = cookie.getValue();
                break;
            }
        }
        return result;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CORS {
        public String allowFrom();

        public boolean allowCredentials();
    }
}

