/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.riversun.oauth2.google.OAuthUtil;

public class OAuthSecrets {
    private static GoogleClientSecrets sGoogleClientSecrets = null;

    public static void setClientSecrets(GoogleClientSecrets googleClientSecrets) {
        sGoogleClientSecrets = googleClientSecrets;
    }

    public static void setClientSecrets(String relativeFilePath) throws IOException {
        InputStream is = OAuthUtil.class.getResourceAsStream(relativeFilePath);
        try {
            sGoogleClientSecrets = GoogleClientSecrets.load((JsonFactory)OAuthUtil.JSON_FACTORY, (Reader)new InputStreamReader(is));
        }
        catch (NullPointerException e) {
            throw new RuntimeException("'client_secret.json' not found! Please put your 'client_secret.json' at '" + relativeFilePath + "' " + "or call OAuthSecrets#setClientSecrets(GoogleClientSecrets googleClientSecrets) on initialize.");
        }
    }

    public static GoogleClientSecrets getClientSecrets() throws IOException {
        if (sGoogleClientSecrets == null) {
            OAuthSecrets.setClientSecrets("/client_secret.json");
        }
        return sGoogleClientSecrets;
    }
}

