/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.oauth2.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.riversun.oauth2.google.OAuthUtil;

public class OAuthSession {
    private static final OAuthSession instance = new OAuthSession();

    private OAuthSession() {
    }

    public static OAuthSession getInstance() {
        return instance;
    }

    public void clearOAuth2State(HttpServletRequest req) {
        req.getSession().setAttribute("org.riversun.goauth.session_key_oauth2_done", null);
    }

    public void setRedirectUrlAfterOAuth(HttpServletRequest req, String url) {
        req.getSession().setAttribute("org.riversun.goauth.session_key_redirect_url_after_oauth", (Object)url);
    }

    @Deprecated
    public GoogleCredential getCredential(HttpServletRequest req) throws IOException {
        GoogleCredential credential = (GoogleCredential)req.getSession().getAttribute("org.riversun.goauth.session_key_credential");
        if (credential == null) {
            String accessToken = this.getAccessToken(req);
            String refreshToken = this.getRefreshToken(req);
            credential = OAuthUtil.createCredential(accessToken, refreshToken);
            req.getSession().setAttribute("org.riversun.goauth.session_key_credential", (Object)credential);
        }
        return credential;
    }

    public GoogleCredential createCredential(HttpServletRequest req) throws IOException {
        GoogleCredential credential = OAuthUtil.createCredential(this.getAccessToken(req), this.getRefreshToken(req));
        return credential;
    }

    public String getRefreshToken(HttpServletRequest req) {
        return (String)req.getSession().getAttribute("org.riversun.goauth.session_key_refresh_token");
    }

    public String getAccessToken(HttpServletRequest req) {
        return (String)req.getSession().getAttribute("org.riversun.goauth.session_key_access_token");
    }

    public String getUserId(HttpServletRequest req) {
        String userId = (String)req.getSession().getAttribute("org.riversun.goauth.session_key_payload_sub");
        return userId;
    }
}

