/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.imgkit;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtil {
    private ImageUtil() {
    }

    public static void fillRectByTransparent(Graphics2D g, int x, int y, int width, int height) {
        Composite composite = g.getComposite();
        AlphaComposite alphaComposit = AlphaComposite.getInstance(7, 0.0f);
        g.setComposite(alphaComposit);
        g.fillRect(x, y, width, height);
        g.setComposite(composite);
    }

    public static void fillShapeByTransparent(Graphics2D g, Shape shape, boolean eraseBorder) {
        Composite composite = g.getComposite();
        AlphaComposite alphaComposit = AlphaComposite.getInstance(7, 0.0f);
        g.setComposite(alphaComposit);
        if (eraseBorder) {
            g.draw(shape);
        }
        g.fill(shape);
        g.setComposite(composite);
    }

    public static BufferedImage deepCopyImage(BufferedImage srcImage) {
        BufferedImage outImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), srcImage.getType());
        Graphics2D g = outImage.createGraphics();
        g.drawImage((Image)srcImage, 0, 0, null);
        g.dispose();
        return outImage;
    }

    public static BufferedImage rotateImage(BufferedImage image, int angleDeg) {
        int height = image.getHeight();
        int width = image.getWidth();
        BufferedImage targetImage = new BufferedImage(height, width, image.getType());
        Graphics2D g2d = targetImage.createGraphics();
        AffineTransform transform = new AffineTransform();
        transform.translate(height / 2 - width / 2, width / 2 - height / 2);
        transform.rotate(Math.toRadians(angleDeg), width / 2, height / 2);
        g2d.setTransform(transform);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return targetImage;
    }

    public static BufferedImage loadImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            throw new RuntimeException(file + " failed to load." + e.getMessage());
        }
    }
}

