/*
 * Decompiled with CFR 0.152.
 */
package org.riversun.imgkit;

import java.awt.Color;

public class RGBAColor {
    private final Color mColor;

    public RGBAColor(int r, int g, int b, float alpha) {
        int a = (int)(255.0f * alpha);
        this.mColor = new Color(r, g, b, a);
    }

    public RGBAColor(Color color) {
        this.mColor = color;
    }

    public RGBAColor(int r, int g, int b) {
        this(r, g, b, 1.0f);
    }

    public RGBAColor(String RRGGBB, float alpha) {
        Color c = Color.decode(RRGGBB);
        this.mColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0f * alpha));
    }

    public RGBAColor(String RRGGBB) {
        this(RRGGBB, 1.0f);
    }

    public boolean isTransparent() {
        return this.mColor.getAlpha() == 0;
    }

    public boolean isNotTransparent() {
        return !this.isTransparent();
    }

    public Color getColor() {
        return this.mColor;
    }
}

